﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.IO;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 多文件上传
    /// </summary>
    public abstract class UploadAttachmentHandler : IHttpHandler
    {

        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            string fileSaveDirectory = string.Empty;

            //获取实体属性 并创建实体 根据创建的实体获取 对应附件的上传地址
            fileSaveDirectory = CreateEntity(context);

            ////保存上传的附件
            //if (!string.IsNullOrEmpty(fileSaveDirectory))
            //    SaveAttachmentToDisk(fileSaveDirectory, context);

            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        /// <summary>
        /// 创建实体,并返回上传文件的路径
        /// </summary>
        protected abstract string CreateEntity(HttpContext context);

        /// <summary>
        /// 将附件保存到此旁
        /// </summary>
        private void SaveAttachmentToDisk(string directory, HttpContext context)
        {
            //TODO: Filedata是上传文件的控件 
            HttpPostedFile attachment_upload = context.Request.Files["Filedata"];
            DirectoryInfo uploadFileDirectory = new DirectoryInfo(directory);

            if (!uploadFileDirectory.Exists)
            {
                uploadFileDirectory = Directory.CreateDirectory(directory);
            }
            string fullFilePath = string.Format("{0}\\{1}", directory, attachment_upload.FileName);
            using (FileStream fs = new FileStream(fullFilePath, FileMode.Create, FileAccess.Write, FileShare.None))
            {
                byte[] buffer = new byte[256 * 1024];
                int bytes;
                attachment_upload.InputStream.Seek(0, SeekOrigin.Begin);
                while ((bytes = attachment_upload.InputStream.Read(buffer, 0, 256 * 1024)) > 0)
                    fs.Write(buffer, 0, bytes);

                fs.Flush();
                fs.Close();
                fs.Dispose();
            }
        }

        #endregion
    }
}
