﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Drawing;

namespace SpaceBuilder.Common.Handlers
{
    public class UploadCompanyLogoHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentAssociateID = Convert.ToInt32(context.Request["associateID"]);

            if (currentAssociateID < 1)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }
            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            User currentDomainUser = Users.GetUser(currentAssociateID, false);
            if (currentDomainUser == null || currentDomainUser.UserType != UserTypes.CompanyUser)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            System.Web.HttpPostedFile LogoFile = context.Request.Files["Filedata"];

            if (LogoFile == null || LogoFile.ContentLength == 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            //if (LogoFile.ContentLength > 512 * 1024)
            //{
            //    context.Response.StatusCode = 403;
            //    context.Response.End();
            //}

            //Todo: 类型判断
            string uploadPhotoTypes = "gif,jpg,jpeg,png,bmp;";
            string[] types = uploadPhotoTypes.Split(',');
            string fileTypeString = LogoFile.FileName.Substring(LogoFile.FileName.LastIndexOf(".") + 1);
            if (types.Count(n => string.Compare(n, fileTypeString, true) == 0) <= 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            //try
            //{
            //    using (Bitmap bitmapOriginal = new Bitmap(LogoFile.InputStream))
            //    {
            //        if (bitmapOriginal.Width > 480 || bitmapOriginal.Height > 60)
            //        {
            //            context.Response.StatusCode = 403;
            //            context.Response.End();
            //        }
            //    }
            //}
            //catch { }


            Avatars.UploadCompanyLogo(currentDomainUser.UserID, LogoFile.InputStream);
            context.Response.StatusCode = 200;
            context.Response.Write("{refresh:true}");
            context.Response.End();
        }


        #endregion
    }
}
