﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Drawing;

namespace SpaceBuilder.Common.Handlers
{
    public class UploadUserAvatarHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentAssociateID = Convert.ToInt32(context.Request["associateID"]);

            if (currentAssociateID < 1)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }
            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            User currentDomainUser = Users.GetUser(currentAssociateID, false);
            if (currentDomainUser == null || !(currentDomainUser.UserID == currentUser.UserID || currentUser.IsContentAdministrator))
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            System.Web.HttpPostedFile LogoFile = context.Request.Files["Filedata"];

            if (LogoFile == null || LogoFile.ContentLength == 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            if (LogoFile.ContentLength > 5 * 1024 * 1024)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            //if (!currentUser.IsContentAdministrator && LogoFile.ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            //{
            //    context.Response.StatusCode = 403;
            //    context.Response.End();
            //}

            //Todo: 类型判断
            string uploadPhotoTypes = "gif,jpg,jpeg,png,bmp;";
            string[] types = uploadPhotoTypes.Split(',');
            string fileTypeString = LogoFile.FileName.Substring(LogoFile.FileName.LastIndexOf(".") + 1);
            if (types.Count(n => string.Compare(n, fileTypeString, true) == 0) <= 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }
            context.Response.StatusCode = 200;
            try
            {
                SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
                using (Bitmap bitmapOriginal = new Bitmap(LogoFile.InputStream))
                {
                    if (bitmapOriginal.Width < siteSettings.SmallAvatarWidth || bitmapOriginal.Height < siteSettings.SmallAvatarHeight)
                    {
                        context.Response.Write(string.Format("{{message:'上传图片低于最小尺寸限制：{0}×{1}'}}", siteSettings.SmallAvatarWidth, siteSettings.SmallAvatarHeight));
                        context.Response.End();
                    }
                    if (bitmapOriginal.Width < 160 || bitmapOriginal.Height < 160)
                    {
                        Avatars.DeleteAvatar(currentDomainUser.UserID);
                        context.Response.Write("{refresh:true}");
                    }
                    else
                        context.Response.Write("{ok:true}");

                    Avatars.UploadOriginalAvatar(currentDomainUser.UserID, LogoFile.InputStream);
                    context.Response.End();

                }
            }
            catch { }

        }


        #endregion
    }
}
