﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

using SpaceBuilder.Web;


namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 生成VCard
    /// </summary>
    public class VCardHandler : IHttpHandler
    {
        #region IHttpHandler Members

        public void ProcessRequest(HttpContext context)
        {
            try
            {
                int userID = -1;
                int contactID = -1;
                userID = context.Request.QueryString.GetInt("UserID",-1);
                contactID = context.Request.QueryString.GetInt("ContactID", -1);

                if (contactID>0)
                {
                    //Contact ct = Contacts.GetContact(contactID);
                    //if (SBContext.Current.User.UserID == ct.UserID)
                    //{
                    //    ct = ConvertContactForEdit(ct);
                    //    context.Response.ContentType = "text/x-vcard";
                    //    string filename = HttpUtility.UrlEncode(ct.DisplayName + string.Format("(From {0})", SiteSettingsManager.GetSiteSettings().SiteName) + ".vcf");
                    //    context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);

                    //    VCardHelper.ExportToVCard(context.Response.OutputStream, new VCardWraper(ct).VContact);
                    //}
                }
                else if (userID>0)
                {
                    User user = Users.GetUser(userID, false);
                    Contact ct = Contacts.ConvertUserToContact(Globals.GetCurrentUser(),user);
                    ct = ConvertContactForEdit(ct);
                    context.Response.ContentType = "text/x-vcard";
                    string filename = HttpUtility.UrlEncode(ct.DisplayName + string.Format("(From {0})", SiteSettingsManager.GetSiteSettings().SiteName) + ".vcf");
                    context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);

                    VCardHelper.ExportToVCard(context.Response.OutputStream, (new VCardWraper(ct)).VContact);
                }

                context.Response.Cache.SetCacheability(HttpCacheability.Public);
                context.Response.Cache.SetExpires(DateTime.Now.AddMinutes(30));
                context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                context.Response.Cache.SetValidUntilExpires(true);
                context.Response.Cache.VaryByParams["ContactID"] = true;
                context.Response.Cache.VaryByParams["UserID"] = true;
            }
            catch (Exception ex)
            {
                context.Response.Write(ex.ToString());
            }
        }

        public bool IsReusable
        {
            get { return true; }
        }

        #endregion


        /// <summary>
        /// 编辑前进行转化
        /// </summary>
        private static Contact ConvertContactForEdit(Contact contact)
        {
            contact.DisplayName = Formatter.FormatMultiLinePlainTextForEdit(contact.DisplayName, false);
            contact.PersonEmail = Formatter.FormatMultiLinePlainTextForEdit(contact.PersonEmail, false);
            contact.Mobile = Formatter.FormatMultiLinePlainTextForEdit(contact.Mobile, false);
            contact.HomeTel = Formatter.FormatMultiLinePlainTextForEdit(contact.HomeTel, false);
            contact.MsnIM = Formatter.FormatMultiLinePlainTextForEdit(contact.MsnIM, false);
            contact.YahooIM = Formatter.FormatMultiLinePlainTextForEdit(contact.YahooIM, false);
            contact.QQIM = Formatter.FormatMultiLinePlainTextForEdit(contact.QQIM, false);
            contact.SkypeIM = Formatter.FormatMultiLinePlainTextForEdit(contact.SkypeIM, false);
            contact.Title = Formatter.FormatMultiLinePlainTextForEdit(contact.Title, false);
            contact.CompanyName = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyName, false);
            contact.WorkTel = Formatter.FormatMultiLinePlainTextForEdit(contact.WorkTel, false);

            #region
            contact.Nickname = Formatter.FormatMultiLinePlainTextForEdit(contact.Nickname, false);
            contact.HomeFax = Formatter.FormatMultiLinePlainTextForEdit(contact.HomeFax, false);
            contact.PersonArea = Formatter.FormatMultiLinePlainTextForEdit(contact.PersonArea, false);
            contact.PersonAddress = Formatter.FormatMultiLinePlainTextForEdit(contact.PersonAddress, false);
            contact.PersonPostcode = Formatter.FormatMultiLinePlainTextForEdit(contact.PersonPostcode, false);
            contact.PersonWebAddress = Formatter.FormatMultiLinePlainTextForEdit(contact.PersonWebAddress, false);
            contact.CompanyArea = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyArea, false);
            contact.CompanyFax = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyFax, false);
            contact.CompanyAddress = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyAddress, false);
            contact.CompanyPostcode = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyPostcode, false);
            contact.CompanyWebAddress = Formatter.FormatMultiLinePlainTextForEdit(contact.CompanyWebAddress, false);
            contact.Remark = Formatter.FormatMultiLinePlainTextForEdit(contact.Remark, false);
            #endregion

            return contact;
        }
    }
}