﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Drawing;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.SessionState;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 生成验证码
    /// </summary>
    public class VerifyCodeHttpHandler : IHttpHandler
    {
        public void ProcessRequest(HttpContext context)
        {
            //检测验证码请求是不是合法请求
            if (!Globals.IsAllowableReferrer(context.Request))
            {
                WebUtils.Return404(context);
                return;
            }

            HttpContextBase currentContext = new HttpContextWrapper(context);
            bool isremove = false;
            if (!string.IsNullOrEmpty(context.Request.QueryString["isremove"]))
                bool.TryParse(context.Request.QueryString["isremove"], out isremove);
            bool IsUseLineNoise = false;
            if (!string.IsNullOrEmpty(context.Request.QueryString["lineNoise"]))
                bool.TryParse(context.Request.QueryString["lineNoise"], out IsUseLineNoise);

            VerificationCodeDifficultyLevel level = VerificationCodeDifficultyLevel.Normal;
            string strlevel = context.Request.QueryString["level"];
            if (!string.IsNullOrEmpty(strlevel))
            {
                level = (VerificationCodeDifficultyLevel)Enum.Parse(typeof(VerificationCodeDifficultyLevel), strlevel);
            }

            string cookieName = SiteSettingsManager.GetSiteSettings().VerifyCodeCookieName;
            string generatedKey = string.Empty;
            bool addCooikes = false;
            //创建或从缓存取验证码
            string key = null;
            if (context.Request.Cookies[cookieName] != null)
                key = context.Request.Cookies[cookieName].Value;
            if (isremove && !string.IsNullOrEmpty(key))
                VerificationCodeManager.GetCachedTextAndForceExpire(currentContext, getCurrentLevelKey(key, level));

            System.IO.MemoryStream ms = null;
            if (!string.IsNullOrEmpty(key))
                ms = VerificationCodeManager.GetCachedImageStream(getCurrentLevelKey(key, level));

            if (ms == null)
            {
                Size size;
                VerificationCodeImage image = null;
                switch (level)
                {
                    case VerificationCodeDifficultyLevel.Low:
                        size = new Size(85, 35);
                        image = VerificationCodeManager.GenerateAndCacheImage(currentContext, size, 300, out generatedKey, level, CharacterSets.LowercaseLetters, IsUseLineNoise, 4, 4);
                        break;
                    case VerificationCodeDifficultyLevel.Hard:
                        size = new Size(95, 42);
                        image = VerificationCodeManager.GenerateAndCacheImage(currentContext, size, 300, out generatedKey, level, CharacterSets.LettersAndPositiveDigits, IsUseLineNoise, 4, 5);
                        break;
                    default:
                        size = new Size(80, 38);
                        image = VerificationCodeManager.GenerateAndCacheImage(currentContext, size, 300, out generatedKey, level, CharacterSets.PositiveDigits, IsUseLineNoise, 4, 5);
                        break;

                }
                ms = VerificationCodeManager.GetCachedImageStream(getCurrentLevelKey(generatedKey, level));
                VerificationCodeManager.CacheText(currentContext, image.Text, getCurrentLevelKey(generatedKey, level), false, 300);
                addCooikes = true;
            }
            //context.Response.ClearContent();
            if (addCooikes)
            {
                HttpCookie cookie = new HttpCookie(cookieName, generatedKey);
                //cookie.Expires = DateTime.Now.AddSeconds(300);
                context.Response.Cookies.Add(cookie);
            }
            HttpCookie cookieLevel = new HttpCookie(cookieName + "_CurrentLevel", level.ToString());
            //cookieLevel.Expires = DateTime.Now.AddSeconds(300);
            context.Response.Cookies.Add(cookieLevel);
            context.Response.Cache.SetCacheability(HttpCacheability.NoCache);
            context.Response.ContentType = "image/Jpeg";
            context.Response.BinaryWrite(ms.ToArray());
            context.Response.Flush();
            context.Response.End();
        }

        public bool IsReusable
        {
            get { return false; }
        }

        /// <summary>
        /// 获取某一级别的Key
        /// </summary>
        /// <param name="publicKey"></param>
        /// <param name="level"></param>
        /// <returns></returns>
        private string getCurrentLevelKey(string publicKey, VerificationCodeDifficultyLevel level)
        {
            return publicKey + ":" + level.ToString();
        }
    }
}