﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;


namespace SpaceBuilder.Common.Mail
{
    /// <summary>
    /// Email辅助类
    /// </summary>
    public class EmailHelper
    {
        private EmailHelper()
        { }

        public static List<EmailTextToken> GetCommonFields()
        {
            List<EmailTextToken> tokens = new List<EmailTextToken>();
            DateTime now = DateTime.Now;
            SiteSettings settings = SiteSettingsManager.GetSiteSettings();

            // set the timesent and sitename
            tokens.Add(new EmailTextToken("TimeSent", now.ToString(string.Format("dddd, yyyy-MM-dd hh:mm tt [GMT {0}]", settings.SiteTimezone.ToString()))));
            tokens.Add(new EmailTextToken("SiteName", WebUtils.HtmlDecode(HtmlUtils.StripHtmlXmlTags(settings.SiteName)).Trim()));
            tokens.Add(new EmailTextToken("AdminEmailFrom", string.IsNullOrEmpty(settings.NoReplyEmailAddress) ? settings.AdminEmailAddress : settings.NoReplyEmailAddress));

            HttpContext httpContext = HttpContext.Current;
            string hostPath = WebUtils.HostPath(httpContext.Request.Url);

            tokens.Add(new EmailTextToken("LoginUrl", WebUtils.FullPath(hostPath, SiteUrls.Instance().LoginReturnHome())));
            tokens.Add(new EmailTextToken("WebSiteUrl", WebUtils.FullPath(hostPath, SiteUrls.Instance().Home())));

            return tokens;
        }

        public static List<EmailTextToken> GetUserFields(User user)
        {
            List<EmailTextToken> tokens = new List<EmailTextToken>();

            tokens.Add(new EmailTextToken("UserName", user.UserName));
            tokens.Add(new EmailTextToken("DisplayName", user.DisplayName));
            tokens.Add(new EmailTextToken("PublicEmail", user.PublicEmail));
            tokens.Add(new EmailTextToken("LastLogin", Formatter.FormatFriendlyDate(user.LastActivity)));

            HttpContext httpContext = HttpContext.Current;
            string hostPath = WebUtils.HostPath(httpContext.Request.Url);

            tokens.Add(new EmailTextToken("ProfileUrl", WebUtils.FullPath(hostPath, SiteUrls.Instance().UserEditProfile(user))));
            tokens.Add(new EmailTextToken("PasswordChange", WebUtils.FullPath(hostPath, SiteUrls.Instance().UserChangePassword(user))));


            if (user.Password != null)
                tokens.Add(new EmailTextToken("Password", user.Password));

            return tokens;
        }

        //public static List<EmailTextToken> GetPostFields(Post post, bool isHtml)
        //{
        //    List<EmailTextToken> tokens = new List<EmailTextToken>();

        //    tokens.Add(new EmailTextToken("PostedBy", post.User.DisplayName));
        //    tokens.Add(new EmailTextToken("Subject", WebUtils.HtmlDecode(post.Subject)));
        //    tokens.Add(new EmailTextToken("PostDate", post.PostDate.ToString()));

        //    // set the text and html versions
        //    string textPostBody = post.Body.Clone() as string;
        //    string htmlPostBody = post.Body.Clone() as string;

        //    // Convert HTML to plain text
        //    textPostBody = Emails.FormatHtmlAsPlainText(textPostBody);

        //    // Convert plain text to HTML
        //    htmlPostBody = Emails.FormatPlainTextAsHtml(htmlPostBody);

        //    // Finally, trim this post so the user doesn't get a huge email
        //    textPostBody = textPostBody.Trim();
        //    htmlPostBody = htmlPostBody.Trim().Replace("\n", string.Empty).Replace("\r", string.Empty);

        //    tokens.Add(new EmailTextToken("TextPostBody", textPostBody));
        //    tokens.Add(new EmailTextToken("HtmlPostBody", htmlPostBody));

        //    if (isHtml)
        //        tokens.Add(new EmailTextToken("PostBody", htmlPostBody));
        //    else
        //        tokens.Add(new EmailTextToken("PostBody", textPostBody));

        //    return tokens;
        //}

    }
}
