//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Net.Mail;
using System.Xml;
using System.Collections.Generic;

namespace SpaceBuilder.Common.Mail
{
    /// <summary>
    /// Emailģ
    /// </summary>
    /// <remarks>
    /// ǰҪڳз͵EmailȫͨEmailģãʵʱվԱͨ޸ЩģʵEmailݵĸġ
    /// </remarks>
    /// <example>
    /// һ˺עɹԶ͵Emailģ壬ʹøEmailģ巢ʼʱԸģе[SiteName]ȱǽ滻
    /// <note type="implementnotes">
    /// <list type="number">
    ///     <item>
    ///         <description>EmailTemplateж[xxxx]ǣעEmailTemplateEmailʱ滻Щ;</description>
    ///     </item>
    ///     <item>
    ///         <description>EmailTemplateжEmailʱʹ&lt;body&gt;ͬʱ崿ıԼHtmlʽEmailݣҲԷֱ&lt;htmlBody&gt;HtmlʽEmailݣ&lt;textBody&gt;崿ıʽEmailݡ</description>
    ///     </item>
    /// </list>
    /// </note>
    /// <code>
    ///&lt;emails&gt;
    ///&lt;!--
    ///======================================================
    ///     Email sent when user has forgotten his/her password.
    ///======================================================
    ///--&gt;
    ///&lt;email emailType="ForgottenPassword" priority="High"&gt;
    ///&lt;subject&gt;([SiteName]) &lt;/subject&gt;
    ///&lt;from&gt;[AdminEmailFrom]&lt;/from&gt;
    ///&lt;body&gt;
    ///[Name],
    ///
    ///յʼΪ(ĳ)[SiteName]վϵͳʺ룬
    ///ˣ벻ʼ
    ///
    ///Դ¼: 
    ///[ForgottenPasswordUrl]
    ///
    ///
    ///[SiteName]һΪ˱ʺŵİȫʹ̫򵥵롣
    ///
    ///Ϊбʺŵ롣
    ///
    ///
    ///лл,
    ///[SiteName]
    ///
    ///͸ʼIPַ: [IP] 
    ///
    ///&lt;/body&gt;
    ///&lt;/email&gt;
    ///
    ///
    ///&lt;!--
    ///======================================================
    ///    Weblog - New Comment Notification to Owner
    ///======================================================
    ///--&gt;
    ///&lt;email emailType="WeblogCommentNotification" priority="Low"&gt;
    ///&lt;subject&gt;[[BlogName]] -  :: [Title]&lt;/subject&gt;
    ///&lt;from&gt;[AdminEmailFrom]&lt;/from&gt;
    ///&lt;htmlBody&gt;
    ///&lt;p&gt;¡&lt;a href="[PostLink]"&gt;[OriginalPostName]&lt;/a&gt;һµ
    ///&lt;p&gt;
    ///: &lt;a href="[TitleUrl]"&gt;[PostedBy]&lt;/a&gt;&lt;br /&gt;
    ///״̬: &lt;b&gt;[PublishedStatus]&lt;/b&gt;&lt;br /&gt;
    ///&lt;/p&gt;
    ///&lt;/p&gt;
    ///[HtmlPostBody]
    ///
    ///&lt;hr /&gt;
    ///&lt;p&gt;յEmailΪڲ۵Email֪ͨ&lt;/p&gt;
    ///
    ///&lt;/htmlBody&gt;
    ///&lt;textBody&gt;
    ///¡[OriginalPostName]һµۣµַ: [PostLink]
    ///
    ///: [PostedBy]&lt;br /&gt;
    ///״̬: [PublishedStatus]
    ///
    ///
    ///[TextPostBody]
    ///
    ///&lt;/textBody&gt;
    ///&lt;/email&gt;
    ///
    ///&lt;/emails&gt;
    /// </code>
    /// </example>
    public sealed class EmailTemplate
    {
        /// <summary>
        /// EmailģеıǷѾ
        /// </summary>
        private bool isTokensProcessed = false;

        /// <overloads>EmailTemplate</overloads>
        /// <summary>
        /// EmailTemplate
        /// </summary>
        public EmailTemplate() { }

        /// <summary>
        /// EmailTemplate
        /// </summary>
        /// <param name="node">EmailTemplatexmlĵڵ</param>
        public EmailTemplate(XmlNode node)
        {
            Priority = (MailPriority)Enum.Parse(Priority.GetType(), node.Attributes.GetNamedItem("priority").InnerText);
            emailType = node.Attributes.GetNamedItem("emailType").InnerText;
            Subject = node.SelectSingleNode("subject").InnerText;

            XmlNode bodyNode = node.SelectSingleNode("body");
            XmlNode textBodyNode = node.SelectSingleNode("textBody");
            XmlNode htmlBodyNode = node.SelectSingleNode("htmlBody");

            if (textBodyNode != null && !string.IsNullOrEmpty(textBodyNode.InnerText))
                TextBody = textBodyNode.InnerText;

            if (htmlBodyNode != null && !string.IsNullOrEmpty(htmlBodyNode.InnerXml))
                HtmlBody = htmlBodyNode.InnerXml;

            if (bodyNode != null && !string.IsNullOrEmpty(bodyNode.InnerText))
            {
                if (string.IsNullOrEmpty(TextBody))
                    TextBody = bodyNode.InnerText;

                if (string.IsNullOrEmpty(HtmlBody))
                    HtmlBody = bodyNode.InnerXml;
                //HtmlBody = EmailTemplates.FormatPlainTextAsHtml(bodyNode.InnerText);
            }

            From = node.SelectSingleNode("from").InnerText;
        }

        #region 

        private string emailType;
        /// <summary>
        /// email;ֵͣEmailģб뱣֤Ψһ
        /// </summary>
        public string EmailType
        {
            get { return emailType; }
            set { emailType = value; }
        }

        private Guid emailID;
        /// <summary>
        /// EmailID
        /// </summary>
        public Guid EmailID
        {
            get { return emailID; }
            set { emailID = value; }
        }

        private int numberOfTries = 0;
        /// <summary>
        /// ʧܵĴ
        /// </summary>
        public int NumberOfTries
        {
            get { return numberOfTries; }
            set { numberOfTries = value; }
        }

        private string from;
        /// <summary>
        /// 
        /// </summary>
        public String From
        {
            get { return from; }
            set { from = value; }
        }

        private string to;
        /// <summary>
        /// ռEmailַ(ַ",")
        /// </summary>
        public String To
        {
            get { return to; }
        }

        private string cc;
        /// <summary>
        /// ͵ַ(ַ",")
        /// </summary>
        public String Cc
        {
            get { return cc; }
        }

        private string bcc;
        /// <summary>
        /// ͵ַ(ַ",")
        /// </summary>
        public String Bcc
        {
            get { return bcc; }
        }

        private string subject = "";
        /// <summary>
        /// Email
        /// </summary>
        public String Subject
        {
            get { return subject; }
            set { subject = value; }
        }

        private string textBody = string.Empty;
        /// <summary>
        /// ıʽEmail
        /// </summary>
        public string TextBody
        {
            get { return textBody; }
            set { textBody = value; }
        }

        private string htmlBody = string.Empty;
        /// <summary>
        /// HtmlʽEmail
        /// </summary>
        public string HtmlBody
        {
            get { return htmlBody; }
            set { htmlBody = value; }
        }

        //private int bodyFormat;
        ///// <summary>
        ///// Emailʽ(0=ı;1=Html)
        ///// </summary>
        //public int BodyFormat
        //{
        //    get { return bodyFormat; }
        //    set
        //    {
        //        bodyFormat = value;
        //        isBodyHtml = (value == 1) ? true : false;
        //    }
        //}

        private bool isBodyHtml;
        /// <summary>
        /// EmailǷHtmlʽ
        /// </summary>
        public bool IsBodyHtml
        {
            get { return isBodyHtml; }
            set
            {
                isBodyHtml = value;
                //bodyFormat = (value == true) ? 1 : 0;
            }
        }

        private MailPriority priority = MailPriority.Normal;
        /// <summary>
        /// Emailȼ
        /// </summary>
        public MailPriority Priority
        {
            get { return priority; }
            set { priority = value; }
        }

        #endregion

        #region 

        /// <summary>
        /// ռEmailַ
        /// </summary>
        /// <param name="otherTo">ӵռEmailַ</param>
        public void AddTo(string otherTo)
        {
            if (string.IsNullOrEmpty(To))
                to = otherTo;
            else
                to += to + "," + otherTo;
        }

        /// <summary>
        /// ӳEmailַ
        /// </summary>
        /// <param name="otherCc">ӵĳEmailַ</param>
        public void AddCc(string otherCc)
        {
            if (string.IsNullOrEmpty(Cc))
                cc = otherCc;
            else
                cc += cc + "," + otherCc;
        }

        /// <summary>
        /// Emailַ
        /// </summary>
        /// <param name="otherBcc">ӵEmailַ</param>
        public void AddBcc(string otherBcc)
        {
            if (string.IsNullOrEmpty(Bcc))
                bcc = otherBcc;
            else
                bcc += bcc + "," + otherBcc;
        }

        /// <summary>
        /// 滻Emailеı
        /// </summary>
        /// <param name="emailTextTokens">EmailģǴ󼯺</param>
        /// <note type="caution">ʹøEmailTemplateEmailʱԱеã滻EmailTemplateеı</note>
        public void ProcessTokens(List<EmailTextToken> emailTextTokens)
        {
            if (!this.isTokensProcessed)
            {
                foreach (EmailTextToken token in emailTextTokens)
                {
                    this.From = token.FormatText(this.From);
                    this.Subject = token.FormatText(this.Subject);
                    this.TextBody = token.FormatText(this.TextBody);
                    this.HtmlBody = token.FormatText(this.HtmlBody);
                }
                this.isTokensProcessed = true;
            }
        }

        #endregion

        #region Clone

        /// <summary>
        /// ¡µEmailTemplate
        /// </summary>
        /// <returns>EmailTemplate</returns>
        internal EmailTemplate Clone()
        {
            EmailTemplate other = new EmailTemplate();
            other.Priority = this.Priority;
            other.EmailType = this.EmailType;
            other.Subject = this.Subject;
            other.TextBody = this.TextBody;
            other.HtmlBody = this.HtmlBody;
            other.From = this.From;
            return other;
        }

        #endregion

    }

}
