//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Collections;
using SpaceBuilder.Common;


namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// Զ
    /// </summary>
    public class AutoCreateFriendGroup : IGlobalModule
    {
        /// <summary>
        /// 캯
        /// </summary>
        public AutoCreateFriendGroup() { }

        /// <summary>
        /// ʼ
        /// </summary>
        public void Init(GlobalEventManager csa, System.Xml.Linq.XElement node)
        {
            csa.AfterUserChange += new UserEventHandler(csa_PostUserUpdate);
        }

        private void csa_PostUserUpdate(User user, GlobalEventArgs e)
        {
            if (user != null && e.State == ObjectState.Create)
            {
                UserCategory userCategory = new UserCategory();

                userCategory.CategoryName = ResourceManager.GetString("Title_DefaultGroup", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().Friend());
                userCategory.PrivacyStatus = PrivacyStatuses.Public;
                userCategory.UserID = user.UserID;

                UserCategoryManager.Instance(MultiUserCategoryItemKeys.Instance().Friend()).CreateUserCategory(userCategory);
            }
        }
    }
}
