﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Web;
using System.Xml.Linq;

namespace SpaceBuilder.Common.Modules
{
    public class DisposeActivityForFriend : IFriendModule
    {
        #region IFriendModule 成员

        public void Init(FriendEventManager em, XElement node)
        {
            em.AfterFriendChange += new FriendEventHandler(em_AfterFriendChange);
        }


        #endregion

        void em_AfterFriendChange(Friend friend, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewFriend();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;

                User user = Users.GetUser(friend.UserID, false);
                User friendUser = Users.GetUser(friend.FriendUserID, false);

                if (user == null || friendUser == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewFriend", user.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), SPBHtmlHelper.Instance().UserDisplayNameLink(friendUser,true));
                userActivity.IsPublic = true;
                userActivity.RelativeItemID = friendUser.UserID;
                userActivity.RelativeItemName = friendUser.DisplayName;

                Activities.CreateUserActivity(userActivity);

                //同时增加朋友的个人动态
                userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = friendUser.UserID;
                userActivity.LeadingActor = friendUser.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewFriend", friendUser.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(friendUser,true), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
                userActivity.IsPublic = true;
                userActivity.RelativeItemID = user.UserID;
                userActivity.RelativeItemName = user.DisplayName;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region 处理朋友动态

                UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                //判断用户是否允许发送给 朋友动态项目
                if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                {
                    FriendActivity friendActivity = new FriendActivity();
                    friendActivity.ApplicationID = activityItem.ApplicationID;
                    friendActivity.ActivityItemID = activityItem.ItemID;
                    friendActivity.LeadingActorUserID = user.UserID;
                    friendActivity.LeadingActor = user.DisplayName;
                    friendActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewFriend", user.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), SPBHtmlHelper.Instance().UserDisplayNameLink(friendUser,true));
                    friendActivity.RelativeItemID = friendUser.UserID;
                    friendActivity.RelativeItemName = friendUser.DisplayName;

                    List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                    Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                }

                //处理朋友的朋友动态
                userActivitySettings = Activities.GetUserActivitySettings(friendUser.UserID, false);
                //判断用户是否允许发送给 朋友动态项目
                if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                {
                    FriendActivity friendActivity = new FriendActivity();
                    friendActivity.ApplicationID = activityItem.ApplicationID;
                    friendActivity.ActivityItemID = activityItem.ItemID;
                    friendActivity.LeadingActorUserID = friendUser.UserID;
                    friendActivity.LeadingActor = friendUser.DisplayName;
                    friendActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewFriend", friendUser.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(friendUser,true), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));

                    friendActivity.RelativeItemID = user.UserID;
                    friendActivity.RelativeItemName = user.DisplayName;

                    List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(friendUser, itemKey);
                    Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                }

                #endregion
            }
        }
    }
}
