﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;


using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// 处理与留言的动态、通知
    /// </summary>
    public class DisposeActivityForGuestBook : IServiceModule
    {

        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterGuestbookPostChange += new GuestbookPostEventHandler(em_AfterGuestbookPostChange);
        }
        /// <summary>
        /// 处理用户留言簿
        /// </summary>
        void em_AfterGuestbookPostChange(GuestbookPost post, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().User()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(post.UserID, false);
                if (user == null)
                    return;

                User guestBookOwner = Users.GetUser(post.GuestbookID, false);
                if (guestBookOwner == null)
                    return;
                //自己给自己留言不做记录
                if (user.UserID == guestBookOwner.UserID)
                    return;

                string itemKey = ActivityItemKeys.Instance().NewUserGuestbookPost();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                if (activityItem == null)
                    return;

                #region 处理个人动态

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewUserGuestbookPost", user.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), SPBHtmlHelper.Instance().UserDisplayNameLink(guestBookOwner,true));
                userActivity.Body = HtmlUtils.TrimHtml(post.Body, 250);

                userActivity.RelativeItemID = post.PostID;
                userActivity.RelativeItemName = post.Subject;

                if (post.IsApproved)
                    userActivity.IsPublic = true;
                else
                    userActivity.IsPublic = false;

                Activities.CreateUserActivity(userActivity);

                #endregion

                #region 处理朋友动态

                if (post.IsApproved)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(guestBookOwner.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = HtmlUtils.TrimHtml(post.Body, 250);

                        friendActivity.RelativeItemID = post.PostID;
                        friendActivity.RelativeItemName = post.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion

            }
        }

        #endregion
    }
}
