//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// ûصĶ̬֪ͨ
    /// </summary>
    public class DisposeActivityForUser : IGlobalModule
    {
        #region IGlobalModule Ա

        /// <summary>
        /// ע¼
        /// </summary>
        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.AfterUserChange += new UserEventHandler(gem_AfterUserChange);

            gem.UpdateAvatar += new UserEventHandler(gem_UpdateAvatar);
        }

        #endregion


        /// <summary>
        /// ûµ
        /// </summary>
        void gem_AfterUserChange(User user, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update)
            {
                string itemKey = ActivityItemKeys.Instance().UpdateProfile();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;

                #region ˶̬

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_UpdateProfile", user.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
                userActivity.IsPublic = true;
                Activities.CreateUserActivity(userActivity);

                #endregion

                #region Ѷ̬

                UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                //жûǷ͸ Ѷ̬Ŀ
                if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                {
                    FriendActivity friendActivity = new FriendActivity();
                    friendActivity.ApplicationID = activityItem.ApplicationID;
                    friendActivity.ActivityItemID = activityItem.ItemID;
                    friendActivity.LeadingActorUserID = user.UserID;
                    friendActivity.LeadingActor = user.DisplayName;
                    friendActivity.Subject = userActivity.Subject;

                    List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                    Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                }

                #endregion
            }
        }


        /// <summary>
        /// ûͷ
        /// </summary>
        void gem_UpdateAvatar(User user, GlobalEventArgs e)
        {
            string itemKey = ActivityItemKeys.Instance().UpdateAvatar();
            ActivityItem activityItem = Activities.GetActivityItem(itemKey);
            if (activityItem == null)
                return;

            #region ˶̬
            UserActivity userActivity = new UserActivity();
            userActivity.ApplicationID = activityItem.ApplicationID;
            userActivity.ActivityItemID = activityItem.ItemID;
            userActivity.LeadingActorUserID = user.UserID;
            userActivity.LeadingActor = user.DisplayName;

            userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_UpdateAvatar", user.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
            userActivity.IsPublic = true;

            Activities.CreateUserActivity(userActivity);
            #endregion

            #region Ѷ̬
            UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
            //жûǷ͸ Ѷ̬Ŀ
            if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
            {
                FriendActivity friendActivity = new FriendActivity();
                friendActivity.ApplicationID = activityItem.ApplicationID;
                friendActivity.ActivityItemID = activityItem.ItemID;
                friendActivity.LeadingActorUserID = user.UserID;
                friendActivity.LeadingActor = user.DisplayName;
                friendActivity.Subject = userActivity.Subject;

                List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
            }
            #endregion

        }



    }
}
