﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Web.Routing;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    class DisposeNoticeForConvertibleGift : IServiceModule
    {
        #region IServiceModule 成员

        void IServiceModule.Init(ServiceEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterConvertibleGiftExchangeApplyChange += new ConvertibleGiftExchangeApplyEventHandler(bem_AfterGiftExchangeApplyChange);
        }

        void bem_AfterGiftExchangeApplyChange(ConvertibleGiftExchangeApply giftExchangeApply, GlobalEventArgs e)
        {
            string itemKey = string.Empty;
            if (giftExchangeApply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Accept)
                itemKey = NoticeItemKeys.Instance().ConvertibleGiftExchangeApplySeuceed();
            else if (giftExchangeApply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Refuse)
                itemKey = NoticeItemKeys.Instance().ConvertibleGiftExchangeApplyFailed();

            NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
            if (noticeItem == null)
                return;
            User toUser = null;
            toUser = Users.GetUser(giftExchangeApply.UserID, false);
            if (toUser == null)
                return;

            NoticeRecord record = new NoticeRecord();
            record.ApplicationID = ApplicationIDs.Instance().Unspecified();
            record.NoticeItemID = noticeItem.ItemID;
            record.NoticeItemKey = noticeItem.ItemKey;
            record.UserID = toUser.UserID;
            record.Receiver = toUser.DisplayName;
            record.LeadingActorUserID = giftExchangeApply.UserID;

            if (giftExchangeApply.GiftID > 0)
            {
                ConvertibleGift gift = ConvertibleGifts.GetGift(giftExchangeApply.GiftID, false);
                record.RelativeItemID = gift.GiftID;
                record.RelativeItemName = gift.Subject;
                record.Subject = string.Format("您申请的礼品{0}", gift.Subject);

            }

            record.LeadingActor = giftExchangeApply.UserDisplayName;
            record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, UserDomainSpecialAppIDs.Instance().Home());

            if (giftExchangeApply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Accept)
                record.Body = string.Format("已被管理员通过");
            else if (giftExchangeApply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Refuse)
                record.Body = "已被管理员拒绝";

            record.ProcessUrl = SPBUrlHelper.Action("ShowGift", "Channel", new RouteValueDictionary { { "giftID", giftExchangeApply.GiftID } }); //SiteUrls.Instance().UserChannelHome(record.UserID, UserDomainSpecialAppIDs.Instance().UserSettingsHome());
            NoticeProcessorFactory.Instance().ProcessNotice(record);
        }
    }

        #endregion

}

