//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    public class DisposeNoticeForFriend : IFriendModule
    {
        #region IFriendModule Ա

        public void Init(FriendEventManager em, System.Xml.Linq.XElement node)
        {
            em.SuccessInviteFriend += new FriendEventHandler(em_SuccessInviteFriend);
        }


        #endregion

        /// <summary>
        /// ɹ 
        /// </summary>
        void em_SuccessInviteFriend(Friend friend, GlobalEventArgs e)
        {
            string itemKey = NoticeItemKeys.Instance().SuccessInviteFriend();
            NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
            if (noticeItem == null)
                return;
            User toUser = Users.GetUser(friend.UserID, false);
            if (toUser == null || friend.FriendUser == null)
                return;
            NoticeRecord record = new NoticeRecord();
            record.ApplicationID = ApplicationIDs.Instance().Friend();
            record.NoticeItemID = noticeItem.ItemID;
            record.NoticeItemKey = noticeItem.ItemKey;
            record.UserID = toUser.UserID;
            record.Receiver = toUser.DisplayName;
            record.LeadingActorUserID = friend.FriendUser.UserID;
            record.LeadingActor = friend.FriendUser.DisplayName;
            record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, UserDomainSpecialAppIDs.Instance().Home());
            record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_SuccessInviteFriend", toUser.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(friend.FriendUser));
            record.ProcessUrl = SiteUrls.Instance().UserChannelHome(record.UserID, UserDomainSpecialAppIDs.Instance().UserSettingsHome());
            NoticeProcessorFactory.Instance().ProcessNotice(record);
        }
    }
}
