//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;


using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// ԵĶ̬֪ͨ
    /// </summary>
    public class DisposeNoticeForGuestBook : IServiceModule
    {

        #region IServiceModule Ա

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterGuestbookPostChange += new GuestbookPostEventHandler(em_AfterGuestbookPostChange);
        }
        /// <summary>
        /// ûԲ
        /// </summary>
        void em_AfterGuestbookPostChange(GuestbookPost post, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().User()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(post.UserID, false);
                if (user == null )
                    return;


                User toUser = null;
                if (post.ParentID > 0)
                {
                    GuestbookPost parentPost = UserGuestbookManager.Instance().GetGuestbookPost(post.ParentID, false);
                    if (parentPost == null)
                        return;
                    toUser = Users.GetUser(parentPost.UserID, false);
                }
                if (toUser == null)
                    toUser = Users.GetUser(post.GuestbookID, false);

                if (toUser == null )
                    return;
                //ԼԼԲ¼
                if (user.UserID == toUser.UserID)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewGuestBookPost();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().User();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.LeadingActorUserID = user.UserID;
                record.LeadingActor = user.DisplayName;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, UserDomainSpecialAppIDs.Instance().Home());
                if (post.ParentID > 0)
                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewUserGuestBookPostBack", toUser.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
                else
                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewUserGuestBookPost", toUser.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
                record.Body = post.Body;
                record.RelativeItemID = post.PostID;
                record.RelativeItemName = post.Subject;
                record.ProcessUrl = SiteUrls.Instance().ListGuestBookPosts(toUser.UserName);
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

        #endregion
    }
}
