//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common.Mail;

using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// ص֪ͨ
    /// </summary>
    public class DisposeNoticeForInvitation : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.NewInvitation += new InvitationEventHandler(em_NewInvitation);
        }

        void em_NewInvitation(Invitation invitation, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Friend() && e.State == ObjectState.Create)
            {
                string itemKey = NoticeItemKeys.Instance().InviteFriend();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User user = Users.GetUser(invitation.SenderUserID, false);
                if (user == null)
                    return;

                User toUser = null;
                toUser = Users.GetUser(invitation.ReceiverUserID, false);
                if (toUser == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Friend();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = toUser.UserID;
                record.Receiver = toUser.UserName;
                record.LeadingActorUserID = invitation.SenderUserID;
                record.LeadingActor = invitation.Sender;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Friend());
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_InviteFriend", toUser.Language, ApplicationIDs.Instance().Friend()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetNameWithHyperlink(toUser));
                record.Body = invitation.Body;
                record.ProcessUrl = SiteUrls.Instance().InvitationInbox(toUser.UserName);
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }
        /// <summary>
        /// ȡӵhtml
        /// </summary>
        private static string GetNameWithHyperlink(User toUser)
        {
            return string.Format("<a {0} href=\"{1}\">" + ResourceManager.GetString("Action_AddFriend", Globals.GetCurrentUserLanguage()) + "</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().InvitationInbox(toUser.UserName));
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;


        #endregion
    }
}
