//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common.Mail;

using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// ˽ص֪ͨ
    /// </summary>
    public class DisposeNoticeForPrivateMessage : IServiceModule
    {
        #region IServiceModule Ա
        /// <summary>
        /// ע¼
        /// </summary>
        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.NewPrivateMessage += new PrivateMessageEventHandler(em_NewPrivateMessage);

            em.ReplyPrivateMessage += new PrivateMessageEventHandler(em_ReplyPrivateMessage);
        }

        #endregion

        /// <summary>
        /// ˽
        /// </summary>
        void em_NewPrivateMessage(PrivateMessage pm, PrivateMessagePost privateMessagePost, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = NoticeItemKeys.Instance().NewPrivateMessage();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User user = null;
                user = Users.GetUser(pm.SenderUserID, false);
                User toUser = null;
                toUser = Users.GetUser(pm.ReceiverUserID, false);
                if (user == null || toUser == null)
                    return;

                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().User();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = toUser.UserID;
                record.Receiver = toUser.UserName;
                record.LeadingActorUserID = pm.SenderUserID;
                record.LeadingActor = pm.Sender;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, UserDomainSpecialAppIDs.Instance().Home());
                record.RelativeItemID = pm.ThreadID;
                record.RelativeItemName = pm.Subject;
                record.RelativeItemUrl = SiteUrls.Instance().ShowPrivateMessage(toUser.UserName, pm.ThreadID);
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewPrivateMessage", toUser.Language, ApplicationIDs.Instance().User()), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true));
                record.Body = pm.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ˽Żظ
        /// </summary>
        void em_ReplyPrivateMessage(PrivateMessage pm, PrivateMessagePost privateMessagePost, GlobalEventArgs e)
        {
            User receiver = null;
            User sender = null;
            if (privateMessagePost.UserID == pm.SenderUserID)
            {
                receiver = Users.GetUser(pm.ReceiverUserID, false);
                sender = Users.GetUser(pm.SenderUserID, false);
            }
            else
            {
                receiver = Users.GetUser(pm.SenderUserID, false);
                sender = Users.GetUser(pm.ReceiverUserID, false);
            }
            
            if (receiver == null || sender == null)
                return;
            string itemKey = NoticeItemKeys.Instance().NewPrivateMessage();
            NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
            if (noticeItem == null)
                return;

            NoticeRecord record = new NoticeRecord();
            record.ApplicationID = ApplicationIDs.Instance().Friend();
            record.NoticeItemID = noticeItem.ItemID;
            record.NoticeItemKey = noticeItem.ItemKey;
            record.UserID = receiver.UserID;
            record.Receiver = receiver.UserName;
            record.LeadingActorUserID = sender.UserID;
            record.LeadingActor = sender.DisplayName;
            record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, UserDomainSpecialAppIDs.Instance().Home());
            record.RelativeItemID = pm.ThreadID;
            record.RelativeItemName = pm.Subject;
            record.RelativeItemUrl = SiteUrls.Instance().ShowPrivateMessage(receiver.UserName, pm.ThreadID);
            record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewPrivateMessage", sender.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(sender,true));
            record.Body = privateMessagePost.Body;
            NoticeProcessorFactory.Instance().ProcessNotice(record);
        }
    }
}