﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Web.Routing;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Modules
{
    class DisposePointForConvertibleGift : IServiceModule
    {
        #region IServiceModule 成员

        void IServiceModule.Init(ServiceEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterConvertibleGiftExchangeApplyChange += new ConvertibleGiftExchangeApplyEventHandler(bem_AfterGiftExchangeApplyChange);
        }

        void bem_AfterGiftExchangeApplyChange(ConvertibleGiftExchangeApply giftExchangeApply, GlobalEventArgs e)
        {
            if (giftExchangeApply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Accept)
            {
                ConvertibleGift gift = ConvertibleGifts.GetGift(giftExchangeApply.GiftID, false);
                string giftName = string.Empty;
                if (gift != null)
                    giftName = gift.Subject;

                UserPointRecord record = new UserPointRecord();
                record.Description = string.Format("花费{0}积分，兑换了{1}个礼品{2}", giftExchangeApply.Price, giftExchangeApply.TotalCount, giftName);
                record.PointCategory = UserPointCategory.Trade;

                record.PointItemName = "兑换礼品";
                record.Points = -giftExchangeApply.Price;
                record.UserID = giftExchangeApply.UserID;
                Points.CreateUserPointRecord(record);
            }

        }
    }

        #endregion

}

