//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;


namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// صĻ
    /// </summary>
    public class DisposePointForFriend : IFriendModule
    {
        #region IFriendModule Ա

        public void Init(FriendEventManager em, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                em.AfterFriendChange += new FriendEventHandler(em_AfterFriendChange);

                em.SuccessInviteFriend += new FriendEventHandler(em_SuccessInviteFriend);
            }
        }

        #endregion

        void em_AfterFriendChange(Friend friend, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Delete)
            {
                List<UserPointRecord> records = new List<UserPointRecord>();
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(friend.UserID, false);
                User friendUser = Users.GetUser(friend.FriendUserID, false);

                if (user == null || friendUser == null)
                    return;

                if (e.State == ObjectState.Create)
                {

                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateFriend());

                    if (role == null)
                        return;
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateFriend", user.Language, ApplicationIDs.Instance().Friend()), friendUser.DisplayName);
                    records = Points.PopulateUserPointRecords(role, friend.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                }
                else if (e.State == ObjectState.Delete)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteFriend());

                    if (role == null)
                        return;
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteFriend", user.Language, ApplicationIDs.Instance().Friend()), friendUser.DisplayName);
                    records = Points.PopulateUserPointRecords(role, friend.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                }

                Points.CreateUserPointRecords(records);
            }
        }

        void em_SuccessInviteFriend(Friend friend, GlobalEventArgs e)
        {
            UserPointItemRole role = null;
            User user = Users.GetUser(friend.UserID, false);
            User friendUser = Users.GetUser(friend.FriendUserID, false);
            if (user == null || friendUser == null)
                return;

            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().SuccessInviteFriend());
            if (role == null)
                return;
            string userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SuccessInviteFriend", user.Language, e.ApplicationID), friendUser.DisplayName);

            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, friend.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }
    }
}
