//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;


namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// صĻ
    /// </summary>
    public class DisposePointForInvitation : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.InvitationStatusChange += new InvitationEventHandler(gem_InvitationStatusChange);
            }
        }

        void gem_InvitationStatusChange(Invitation invitation, GlobalEventArgs e)
        {
            if (invitation.Status != InvitationStatuses.Accept)
                return;
            UserPointItemRole role = null;
            string itemKey = UserPointItemKeys.Instance().InviteFriend();
            role = Points.GetUserPointItemRole(itemKey);
            User sender = Users.GetUser(invitation.SenderUserID, false);
            if (sender == null)
                return;

            string roleItemName = role.GetMultilingualItemName(Globals.GetCurrentUserLanguage());

            if (role == null)
                return;
            string userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_InviteFriend", sender.Language, ApplicationIDs.Instance().Friend()), invitation.Receiver);

            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, invitation.SenderUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        #endregion

    }
}
