﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace SpaceBuilder.Common.Modules
{
    public class DisposePointForRecommendUser : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, XElement node)
        {
            em.RecommendedItemChange += new RecommendedItemEventHandler(em_RecommendedItemChange);
        }

        /// <summary>
        /// 处理用户推荐积分
        /// </summary>
        void em_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().User() && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;

                UserPointItemRole role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().RecommendedUser());
                if (role == null)
                    return;
                string userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedUser", user.Language, e.ApplicationID), commendedItem.ItemName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        #endregion
    }
}
