//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;


namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// ûصĻ
    /// </summary>
    public class DisposePointForUser : IGlobalModule
    {

        #region IGlobalModule Ա

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.AfterUserChange += new UserEventHandler(gem_AfterUserChange);
                gem.UserFirstUploadAvatar += new UserEventHandler(gem_UserFirstUploadAvatar);
            }
        }

        /// <summary>
        /// ûע
        /// </summary>
        void gem_AfterUserChange(User user, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                UserPointItemRole role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().Register());

                if (role == null)
                    return;
                string userPointRecordDescription = ResourceManager.GetString("Title_Pattern_Point_Register", user.Language, ApplicationIDs.Instance().User());
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, user.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);

            }
        }

        /// <summary>
        /// ϴͷ
        /// </summary>
        void gem_UserFirstUploadAvatar(User user, GlobalEventArgs e)
        {
            UserPointItemRole role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().UploadAvatar());

            if (role == null)
                return;

            string userPointRecordDescription = ResourceManager.GetString("Title_Pattern_Point_UploadAvatar", user.Language, ApplicationIDs.Instance().User());
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, user.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);
        }

        #endregion
    }
}
