﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SpaceBuilder.Common.Modules
{
    public class DisposeUserRankChanged : IGlobalModule
    {
        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserRankChange += new UserRankChangedHandler(gem_UserRankChange);
        }

        void gem_UserRankChange(User user, int oldRank)
        {
            //int noModeratedUserRank = SiteSettingsManager.GetSiteSettings().NoModera tedUserPoint;
            //if (user.IsModerated && user.Rank >= noModeratedUserRank)
            //    user.IsModerated = false;
            if (oldRank < 1)
                return;
            int userRankDvalue = user.Rank - oldRank;
            user.DatabaseQuota = user.DatabaseQuota + userRankDvalue * SiteSettingsManager.GetSiteSettings().DatabaseQuotaIntervalValue;
            Users.UpdateDatabaseQuotaUsed(user);
        }

        #endregion
    }
}
