﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Web;

namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// SPBException 处理Module
    /// </summary>
    public class ExceptionModule : IGlobalModule
    {

        #region IGlobalModule Members

        /// <summary>
        /// 初始化（进行相应事件处理程序的注册）
        /// </summary>
        /// <param name="em">全局事件管理器</param>
        /// <param name="node">配置文件中的相应节点</param>
        public void Init(GlobalEventManager em, System.Xml.Linq.XElement node)
        {
            em.SPBException += new SPBExceptionHandler(em_SPBException);
        }

        #endregion

        /// <summary>
        /// 处理SPBException，在信息提示页面显示异常信息
        /// </summary>
        private void em_SPBException(SPBException exception, GlobalEventArgs e)
        {
            HttpContext httpContext = HttpContext.Current;
            if (httpContext != null)
            {
                if (exception.ExceptionType != ExceptionTypes.Instance().UnknownError())
                    httpContext.Response.Redirect(SiteUrls.Instance().ShowExceptionMessage(exception.ExceptionType), true);
                else
                    httpContext.Response.Redirect(SiteUrls.Instance().ShowExceptionMessage(exception.ExceptionType,exception.Message), true);
            }
            
        }

    }
}

