﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using System.Xml.Linq;

namespace SpaceBuilder.Common.Modules
{
    public class FriendFormatting : IFriendModule
    {
        #region IFriendModule 成员

        public void Init(FriendEventManager em, XElement node)
        {
            em.BeforeFriendChange += new FriendEventHandler(em_BeforeFriendChange);
        }

        void em_BeforeFriendChange(Friend friend, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update)
            {
                friend.Remark = WebUtils.HtmlEncode(friend.Remark);
                friend.Remark = Censors.CensorPost(friend.Remark);
            }
        }

        #endregion
    }
}
