﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;



namespace SpaceBuilder.Common.Modules
{
    /// <summary>
    /// 格式化留言内容
    /// </summary>
    public class GuestbookPostFormatting : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeGuestbookPostChange += new GuestbookPostEventHandler(em_BeforeGuestbookPostChange);
        }

        void em_BeforeGuestbookPostChange(GuestbookPost post, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                post.Body = Formatter.FormatPlainTextComment(post.Body);
                if (post.UserID == 0)
                {
                    post.Author = Formatter.FormatSingleLinePlainTextForStorage(post.Author);
                }

                if (SPBConfig.Instance().EnableEmoticon)
                    post.Body = EmotionManager.Instance().EmoticonTransforms(post.Body);
            }
        }

        #endregion
    }
}
