﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using System.Xml.Linq;

namespace SpaceBuilder.Common.Modules
{
    public class UserFormatting : IGlobalModule
    {
        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, XElement node)
        {
            gem.BeforUserChange += new UserEventHandler(gem_BeforUserChange);
        }

        void gem_BeforUserChange(User user, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                CompanyUser cu = user as CompanyUser;
                if (user.UserType == UserTypes.CompanyUser && cu != null)
                {
                    cu.Address = Formatter.FormatSingleLinePlainTextForStorage(cu.Address);
                    cu.CommonName = Formatter.FormatSingleLinePlainTextForStorage(cu.CommonName);
                    cu.Fax = Formatter.FormatSingleLinePlainTextForStorage(cu.Fax);
                    //cu.Intro = Formatter.FormatMultiLinePlainTextForStorage(cu.Intro, false, false);
                    cu.Licence = Formatter.FormatSingleLinePlainTextForStorage(cu.Licence);
                    cu.Linkman = Formatter.FormatSingleLinePlainTextForStorage(cu.Linkman);
                    cu.LinkmanDuty = Formatter.FormatSingleLinePlainTextForStorage(cu.LinkmanDuty);
                    cu.LinkTel = Formatter.FormatSingleLinePlainTextForStorage(cu.LinkTel);
                    cu.Mobile = Formatter.FormatSingleLinePlainTextForStorage(cu.Mobile);
                    cu.MsnIM = Formatter.FormatSingleLinePlainTextForStorage(cu.MsnIM);
                    cu.NickName = Formatter.FormatSingleLinePlainTextForStorage(cu.NickName);
                    cu.PersonalHomepage = Formatter.FormatSingleLinePlainTextForStorage(cu.PersonalHomepage);
                    cu.Postcode = Formatter.FormatSingleLinePlainTextForStorage(cu.Postcode);
                    cu.PublicEmail = Formatter.FormatSingleLinePlainTextForStorage(cu.PublicEmail);
                    cu.QQIM = Formatter.FormatSingleLinePlainTextForStorage(cu.QQIM);
                    cu.SkypeIM = Formatter.FormatSingleLinePlainTextForStorage(cu.SkypeIM);
                    cu.UserDomainDescription = Formatter.FormatMultiLinePlainTextForStorage(cu.UserDomainDescription, false);
                    cu.UserDomainTitle = Formatter.FormatMultiLinePlainTextForStorage(cu.UserDomainTitle, false);
                    cu.YahooIM = Formatter.FormatSingleLinePlainTextForStorage(cu.YahooIM);
                }
            }
        }

        #endregion
    }
}
