//</TunynetCopyright>
//--------------------------------------------------------------
//<copyright>Ƽ޹˾ 2005-2011</copyright>
//<version>V0.5</verion>
//<createdate>2011-8-18</createdate>
//<author>zhengw</author>
//<email>zhengw@tunynet.com</email>
//<log date="2011-8-18"></log>
//--------------------------------------------------------------
//</TunynetCopyright>

using MSNPSharp;
using System;
using System.ComponentModel;
using System.Threading;
using System.Collections.Generic;

namespace SpaceBuilder.Common
{
    public class GetAddressByMsn
    {
        private Messenger messenger = new Messenger();
        private int tmpCount = 1;

        public List<MsnFriend> GetFriends(string username, string password, bool IsPageAsync)
        {
            if (!this.messenger.Nameserver.IsSignedIn)
            {
                try
                {
                    this.Login(username, password, IsPageAsync);
                }
                catch { }
            }
            List<MsnFriend> friends = new List<MsnFriend>();
            foreach (MSNPSharp.Contact contact in this.messenger.Nameserver.ContactList.Values)
            {
                MsnFriend friend = new MsnFriend
                {
                    Name = contact.Name,
                    Email = contact.Mail,
                    HomePhone = contact.HomePhone,
                    WordkPhone = contact.WorkPhone,
                    MobilePhone = contact.MobilePhone,
                    IsOnline = contact.Online
                };
                friends.Add(friend);
            }
            return friends;
        }

        private void Login(string username, string password, bool IsPageAsync)
        {
            if (IsPageAsync)
            {
                SynchronizationContext context = AsyncOperationManager.SynchronizationContext;
                try
                {
                    AsyncOperationManager.SynchronizationContext = new SynchronizationContext();
                    this.messenger.Credentials = new Credentials(username, password, (MsnProtocol)Enum.Parse(typeof(MsnProtocol), MsnProtocol.MSNP16.ToString()));
                    this.messenger.Connect();
                    Thread.Sleep(0xbb8);
                    while (this.tmpCount < 2)
                    {
                        if (!(this.messenger.Connected && !this.messenger.Nameserver.IsSignedIn))
                        {
                            this.tmpCount++;
                            this.Login(username, password, IsPageAsync);
                        }
                    }
                }
                catch{}
                finally
                {
                    AsyncOperationManager.SynchronizationContext = context;
                }
            }
        }
    }
}

