﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 索引文件报告
    /// </summary>
    public class IndexFileReport
    {

        public IndexFileReport(string indexFileDirectory)
        {
            this.indexFileDirectory = indexFileDirectory;
            physicalIndexDirectory = System.IO.Path.Combine(SearchConfiguration.Instance().GlobalIndexDirectory, indexFileDirectory);
            List<SearchTypeSettingsBase> searchTypeSettinss = SearchConfiguration.Instance().SearchTypeSettingss.IndexDictionary[indexFileDirectory];
            if (searchTypeSettinss != null)
            {
                searchNames = new string[searchTypeSettinss.Count];
                for (int i = 0; i < searchTypeSettinss.Count; i++)
                {
                    searchNames[i] = searchTypeSettinss[i].SearchName;
                }
            }

            if (Directory.Exists(physicalIndexDirectory))
            {
                FileInfo[] _indexFiles = (new DirectoryInfo(physicalIndexDirectory)).GetFiles("*.*");
                if (_indexFiles != null && _indexFiles.Length > 0)
                {
                    foreach (FileInfo file in _indexFiles)
                    {
                        this.indexFileSize += file.Length;
                        if (file.LastWriteTime > this.lastModified)
                            this.lastModified = file.LastWriteTime;
                    }
                }
            }
        }

        private string indexFileDirectory = string.Empty;
        /// <summary>
        /// 索引文件所在目录
        /// </summary>
        public string IndexFileDirectory
        {
            get { return indexFileDirectory; }
        }

        private string physicalIndexDirectory = string.Empty;
        /// <summary>
        /// 索引文件物理路径
        /// </summary>
        public string PhysicalIndexDirectory
        {
            get { return physicalIndexDirectory; }
        }

        private long indexFileSize = 0L;
        /// <summary>
        /// 索引文件大小
        /// </summary>
        public long IndexFileSize
        {
            get { return indexFileSize; }
        }

        private DateTime lastModified = DateTime.MinValue;
        /// <summary>
        /// 上次更新
        /// </summary>
        public DateTime LastModified
        {
            get { return lastModified; }
        }

        private string[] searchNames = null;
        /// <summary>
        /// 索引类型
        /// </summary>
        public string[] SearchNames
        {
            get 
            {
                if (searchNames == null)
                    searchNames = new string[0];

                return searchNames; 
            }
        }

    }
}
