//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.Tasks;
using System.Xml.Linq;
using System.Linq;


namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// ڰPersonUserıµLuceneļ
    /// </summary>
    public class PersonUserIndexTask : TaskBase
    {
        /// <summary>
        /// ÿθĿ
        /// </summary>
        private int count = 1000;

        #region ITask Members

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                try
                {
                    count = int.Parse(countNode.Value);
                }
                catch
                {
                    count = 1000;
                }
            }

            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(PersonUserSearchTypeSettings.CODE, count);

            List<ItemForIndex> createItems = new List<ItemForIndex>();
            List<ItemForIndex> updateItems = new List<ItemForIndex>();
            List<ItemForIndex> deleteItems = new List<ItemForIndex>();

            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            #region Insert

            IList<PersonUser> createUsers = new List<PersonUser>();
            foreach (ItemForIndex item in createItems)
            {                
                PersonUser pu = Users.GetUser(item.ItemID, true) as PersonUser;
                if (pu != null)
                    createUsers.Add(pu);
            }

            if (PersonUserSearchManager.Instance().Insert(createUsers))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<PersonUser> updateUsers = new List<PersonUser>();
            foreach (ItemForIndex item in updateItems)
            {
                PersonUser pu = Users.GetUser(item.ItemID, true) as PersonUser;
                if (pu != null)
                    updateUsers.Add(pu);
            }

            if (PersonUserSearchManager.Instance().Update(updateUsers, m => m.Select(n => n.UserID).ToList(), PersonUserIndexFields.UserID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && PersonUserSearchManager.Instance().Delete(deleteItems.Select(n => n.ItemID).ToList(), PersonUserIndexFields.UserID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion

        }

        #endregion





    }
}
