//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Text;
using Lucene.Net.Analysis;
using Lucene.Net.Documents;
using System.Collections;
using Lucene.Net.QueryParsers;
using Lucene.Net.Analysis.Standard;
using SpaceBuilder.Common;
using Lucene.Net.Search;
using Lucene.Net.Index;
using System.IO;
using Lucene.Net.Store;
using SpaceBuilder.Utils;
using System.Diagnostics;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// Luceneļӡ޸ġɾ
    /// </summary>
    /// <remarks>
    /// ʹRangeQuery
    /// </remarks>
    public class PersonUserSearchManager : SearchManagerBase<PersonUser>
    {
        /// <summary>
        /// ļĿ¼
        /// </summary>
        public static readonly string personUserIndexFileDirectory = "PersonUser";
        private static volatile PersonUserSearchManager _self = null;
        private static readonly object lockObject = new object();

        private PersonUserSearchManager(string indexFileDirectory) : base(indexFileDirectory) { }

        public static PersonUserSearchManager Instance()
        {
            if (_self == null)
            {
                lock (lockObject)
                {
                    if (_self == null)
                    {
                        _self = new PersonUserSearchManager(personUserIndexFileDirectory);
                    }
                }
            }

            return _self;
        }

        #region Search
        /// <summary>
        /// 
        /// </summary>
        public SearchResultDataSet<PersonUser> Search(User currentUser, PersonUserFullTextQuery query)
        {
            //ļʱռ
            if (!IsIndexFilesExists)
                return new SearchResultDataSet<PersonUser>();

            BooleanQuery currentQuery = new BooleanQuery();
            BooleanQuery queryForFilter = new BooleanQuery();

            if (!string.IsNullOrEmpty(query.Keyword))
            {
                query.Keyword = StringUtilsForLucene.LuceneKeywordsScrubber(query.Keyword);
                query.Keyword = query.Keyword.Trim();
                if (!string.IsNullOrEmpty(query.Keyword.Trim()))
                {
                    string[] nameSegments = SegmentForPhraseQuery(query.Keyword);
                    if (nameSegments.Length == 1)
                    {
                        string[] searchFieldsForName = new string[3];
                        searchFieldsForName[0] = PersonUserIndexFields.CommonName;
                        searchFieldsForName[1] = PersonUserIndexFields.NickName;
                        searchFieldsForName[2] = PersonUserIndexFields.UserName;

                        MultiFieldQueryParser nameKeywordParser = new MultiFieldQueryParser(CurrentLuceneVersion, searchFieldsForName, GetChineseAnalyzerOfUnTokenized());
                        nameKeywordParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                        nameKeywordParser.SetLowercaseExpandedTerms(true);
                        Query nameQuery = nameKeywordParser.Parse(query.Keyword.ToLower() + "*");
                        nameQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(nameQuery, BooleanClause.Occur.MUST);

                        QueryParser tagQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.Tags, GetChineseAnalyzerOfUnTokenized());
                        Query tagQuery = tagQueryParser.Parse(query.Keyword.ToLower() + "*");
                        tagQuery.SetBoost((float)Math.Pow(3, 3));
                        currentQuery.Add(tagQuery, BooleanClause.Occur.MUST);

                        MultiFieldQueryParser schoolCompanyNameKeywordParser = new MultiFieldQueryParser(CurrentLuceneVersion, new string[] { PersonUserIndexFields.School, PersonUserIndexFields.CompanyName }, GetChineseAnalyzerOfUnTokenized());
                        schoolCompanyNameKeywordParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                        schoolCompanyNameKeywordParser.SetLowercaseExpandedTerms(true);
                        Query schoolCompanyNameQuery = nameKeywordParser.Parse(query.Keyword.ToLower() + "*");
                        schoolCompanyNameQuery.SetBoost((float)Math.Pow(3, 1));
                        currentQuery.Add(schoolCompanyNameQuery, BooleanClause.Occur.MUST);
                    }
                    else
                    {
                        BooleanQuery nameQuery = new BooleanQuery();

                        PhraseQuery commonNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            commonNameQuery.Add(new Term(PersonUserIndexFields.CommonName, nameSegment));

                        commonNameQuery.SetSlop(PhraseQuerySlop);
                        commonNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(commonNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery nickNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            nickNameQuery.Add(new Term(PersonUserIndexFields.NickName, nameSegment));

                        nickNameQuery.SetSlop(PhraseQuerySlop);
                        nickNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(nickNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery userNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            userNameQuery.Add(new Term(PersonUserIndexFields.UserName, nameSegment));

                        userNameQuery.SetSlop(PhraseQuerySlop);
                        userNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(userNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery tagNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            tagNameQuery.Add(new Term(PersonUserIndexFields.Tags, nameSegment));

                        tagNameQuery.SetSlop(PhraseQuerySlop);
                        tagNameQuery.SetBoost((float)Math.Pow(3, 3));
                        nameQuery.Add(tagNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery schoolQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            schoolQuery.Add(new Term(PersonUserIndexFields.School, nameSegment));

                        schoolQuery.SetSlop(PhraseQuerySlop);
                        schoolQuery.SetBoost((float)Math.Pow(3, 1));
                        nameQuery.Add(schoolQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery companyNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            companyNameQuery.Add(new Term(PersonUserIndexFields.UserName, nameSegment));

                        companyNameQuery.SetSlop(PhraseQuerySlop);
                        companyNameQuery.SetBoost((float)Math.Pow(3, 1));
                        nameQuery.Add(companyNameQuery, BooleanClause.Occur.SHOULD);

                        currentQuery.Add(nameQuery, BooleanClause.Occur.MUST);
                    }
                }
            }

            if (!string.IsNullOrEmpty(query.NameKeyword))
            {
                query.NameKeyword = StringUtilsForLucene.LuceneKeywordsScrubber(query.NameKeyword);
                query.NameKeyword = query.NameKeyword.Trim();



                if (!string.IsNullOrEmpty(query.NameKeyword.Trim()))
                {
                    string[] nameSegments = SegmentForPhraseQuery(query.NameKeyword);
                    if (nameSegments.Length == 1)
                    {
                        string[] searchFieldsForKeyword = new string[3];
                        searchFieldsForKeyword[0] = PersonUserIndexFields.CommonName;
                        searchFieldsForKeyword[1] = PersonUserIndexFields.NickName;
                        searchFieldsForKeyword[2] = PersonUserIndexFields.UserName;

                        MultiFieldQueryParser nameKeywordParser = new MultiFieldQueryParser(CurrentLuceneVersion, searchFieldsForKeyword, GetChineseAnalyzerOfUnTokenized());
                        nameKeywordParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                        nameKeywordParser.SetLowercaseExpandedTerms(true);

                        Query nameQuery = nameKeywordParser.Parse(nameSegments[0].ToLower() + "*");
                        nameQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(nameQuery, BooleanClause.Occur.MUST);
                    }
                    else
                    {
                        BooleanQuery nameQuery = new BooleanQuery();

                        PhraseQuery commonNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            commonNameQuery.Add(new Term(PersonUserIndexFields.CommonName, nameSegment));

                        commonNameQuery.SetSlop(PhraseQuerySlop);
                        commonNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(commonNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery nickNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            nickNameQuery.Add(new Term(PersonUserIndexFields.NickName, nameSegment));

                        nickNameQuery.SetSlop(PhraseQuerySlop);
                        nickNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(nickNameQuery, BooleanClause.Occur.SHOULD);

                        PhraseQuery userNameQuery = new PhraseQuery();
                        foreach (var nameSegment in nameSegments)
                            userNameQuery.Add(new Term(PersonUserIndexFields.UserName, nameSegment));

                        userNameQuery.SetSlop(PhraseQuerySlop);
                        userNameQuery.SetBoost((float)Math.Pow(3, 5));
                        nameQuery.Add(userNameQuery, BooleanClause.Occur.SHOULD);

                        currentQuery.Add(nameQuery, BooleanClause.Occur.MUST);
                    }
                }
            }

            if (!string.IsNullOrEmpty(query.IMKeyword))
            {
                query.IMKeyword = StringUtilsForLucene.LuceneKeywordsScrubber(query.IMKeyword);
                string keywordSegments = SegmentForQueryParser(query.IMKeyword);
                if (!string.IsNullOrEmpty(query.IMKeyword))
                {
                    string[] searchFieldsForImKeyword = new string[4];
                    searchFieldsForImKeyword[0] = PersonUserIndexFields.MsnIM;
                    searchFieldsForImKeyword[1] = PersonUserIndexFields.QQIM;
                    searchFieldsForImKeyword[2] = PersonUserIndexFields.SkypeIM;
                    searchFieldsForImKeyword[3] = PersonUserIndexFields.YahooIM;

                    MultiFieldQueryParser imKeywordParser = new MultiFieldQueryParser(CurrentLuceneVersion, searchFieldsForImKeyword, GetChineseAnalyzerOfUnTokenized());
                    imKeywordParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                    imKeywordParser.SetLowercaseExpandedTerms(true);

                    Query postKeywordQuery = imKeywordParser.Parse(keywordSegments);
                    currentQuery.Add(postKeywordQuery, BooleanClause.Occur.MUST);
                }
            }

            if (query.MinAge > 0 || query.MaxAge > 0)
            {
                QueryParser ageQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.BirthdayYear, new WhitespaceAnalyzer());
                StringBuilder birthdayYears = new StringBuilder();
                DateTime now = DateTime.Now;

                int minAge = query.MinAge > 0 ? query.MinAge : 0;
                int maxAge = query.MaxAge > 0 ? query.MaxAge : 100;
                for (int i = minAge; i <= maxAge; i++)
                {
                    if (i == maxAge)
                        birthdayYears.Append((now.Year - i));
                    else
                        birthdayYears.Append((now.Year - i) + " ");
                }
                Query ageQuery = ageQueryParser.Parse(birthdayYears.ToString());
                currentQuery.Add(ageQuery, BooleanClause.Occur.MUST);
            }

            if (query.Gender != Genders.All)
            {
                Term genderTerm = new Term(PersonUserIndexFields.Gender, ((int)query.Gender).ToString());
                Query genderQuery = new TermQuery(genderTerm);
                currentQuery.Add(genderQuery, BooleanClause.Occur.MUST);
            }

            query.NowAreaCode = query.NowAreaCode.Trim();
            if (!string.IsNullOrEmpty(query.NowAreaCode))
            {
                Query nowAreaQuery = new WildcardQuery(new Term(PersonUserIndexFields.NowAreaCode, query.NowAreaCode.TrimEnd('0') + "*"));
                currentQuery.Add(nowAreaQuery, BooleanClause.Occur.MUST);
            }

            query.HomeAreaCode = query.HomeAreaCode.Trim();
            if (!string.IsNullOrEmpty(query.HomeAreaCode))
            {
                Query homeAreaQuery = new WildcardQuery(new Term(PersonUserIndexFields.HomeAreaCode, query.HomeAreaCode.TrimEnd('0') + "*"));
                currentQuery.Add(homeAreaQuery, BooleanClause.Occur.MUST);
            }

            if (!string.IsNullOrEmpty(query.TagName))
            {
                string[] tagSegments = SegmentForPhraseQuery(query.TagName);
                if (tagSegments != null && tagSegments.Length > 0)
                {
                    PhraseQuery tagQuery = new PhraseQuery();
                    foreach (var tagSegment in tagSegments)
                        tagQuery.Add(new Term(PersonUserIndexFields.Tags, tagSegment));

                    tagQuery.SetSlop(PhraseQuerySlop);
                    tagQuery.SetBoost((float)Math.Pow(3, 5));
                    currentQuery.Add(tagQuery, BooleanClause.Occur.MUST);
                }
            }

            if (query.Degree != 0)
            {
                Term degreeTerm = new Term(PersonUserIndexFields.Degree, query.Degree.ToString());
                Query degreeQuery = new TermQuery(degreeTerm);
                currentQuery.Add(degreeQuery, BooleanClause.Occur.MUST);
            }

            if (!string.IsNullOrEmpty(query.School))
            {
                query.School = StringUtilsForLucene.LuceneKeywordsScrubber(query.School);
                if (!string.IsNullOrEmpty(query.School.Trim()))
                {
                    string[] schoolSegments = SegmentForPhraseQuery(query.School);
                    if (schoolSegments.Length == 1)
                    {
                        QueryParser schoolParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.School, GetChineseAnalyzerOfUnTokenized());
                        schoolParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                        schoolParser.SetLowercaseExpandedTerms(true);

                        Query nameQuery = schoolParser.Parse(schoolSegments[0].ToLower() + "*");
                        nameQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(nameQuery, BooleanClause.Occur.MUST);
                    }
                    else
                    {
                        PhraseQuery schoolQuery = new PhraseQuery();
                        foreach (var schoolSegment in schoolSegments)
                            schoolQuery.Add(new Term(PersonUserIndexFields.School, schoolSegment));

                        schoolQuery.SetSlop(PhraseQuerySlop);
                        schoolQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(schoolQuery, BooleanClause.Occur.MUST);
                    }
                }
            }

            if (!string.IsNullOrEmpty(query.Interest))
            {
                Query interestQuery = null;
                query.Interest = StringUtilsForLucene.LuceneKeywordsScrubber(query.Interest.ToLower());
                string interestSegments = SegmentForQueryParser(query.Interest);

                if (!string.IsNullOrEmpty(interestSegments))
                {
                    QueryParser interestParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.Interest, GetChineseAnalyzerOfUnTokenized());
                    interestParser.SetLowercaseExpandedTerms(true);
                    interestParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                    interestQuery = interestParser.Parse(interestSegments);
                    currentQuery.Add(interestQuery, BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.Expertise))
            {
                Query expertiseQuery = null;
                query.Expertise = StringUtilsForLucene.LuceneKeywordsScrubber(query.Expertise.ToLower());
                string expertiseSegments = SegmentForQueryParser(query.Expertise);
                if (!string.IsNullOrEmpty(expertiseSegments))
                {
                    QueryParser expertiseParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.Expertise, GetChineseAnalyzerOfUnTokenized());
                    expertiseParser.SetLowercaseExpandedTerms(true);
                    expertiseParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                    expertiseQuery = expertiseParser.Parse(expertiseSegments);
                    currentQuery.Add(expertiseQuery, BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.CompanyName))
            {
                query.CompanyName = StringUtilsForLucene.CompanyNameScrubber(query.CompanyName);
                if (!string.IsNullOrEmpty(query.CompanyName.Trim()))
                {
                    string[] companyNameSegments = SegmentForPhraseQuery(query.CompanyName);
                    if (companyNameSegments.Length == 1)
                    {
                        QueryParser companyNameParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.CompanyName, GetChineseAnalyzerOfUnTokenized());
                        companyNameParser.SetDefaultOperator(QueryParser.OR_OPERATOR);
                        companyNameParser.SetLowercaseExpandedTerms(true);

                        Query companyNameQuery = companyNameParser.Parse(companyNameSegments[0].ToLower() + "*");
                        companyNameQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(companyNameQuery, BooleanClause.Occur.MUST);
                    }
                    else
                    {
                        PhraseQuery companyNameQuery = new PhraseQuery();
                        foreach (var companyNameSegment in companyNameSegments)
                            companyNameQuery.Add(new Term(PersonUserIndexFields.CompanyName, companyNameSegment));

                        companyNameQuery.SetSlop(PhraseQuerySlop);
                        companyNameQuery.SetBoost((float)Math.Pow(3, 5));
                        currentQuery.Add(companyNameQuery, BooleanClause.Occur.MUST);
                    }
                }
            }

            if (query.CompanyTrade != 0)
            {
                Term companyTradeTerm = new Term(PersonUserIndexFields.CompanyTrade, query.CompanyTrade.ToString());
                Query companyTradeQuery = new TermQuery(companyTradeTerm);
                currentQuery.Add(companyTradeQuery, BooleanClause.Occur.MUST);
            }

            if (!string.IsNullOrEmpty(query.MsnIM))
            {
                query.MsnIM = StringUtilsForLucene.LuceneKeywordsScrubber(query.MsnIM.ToLower());
                if (!string.IsNullOrEmpty(query.MsnIM))
                {
                    QueryParser msneQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.MsnIM, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(msneQueryParser.Parse(query.MsnIM + "*"), BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.YahooIM))
            {
                query.YahooIM = StringUtilsForLucene.LuceneKeywordsScrubber(query.YahooIM.ToLower());
                if (!string.IsNullOrEmpty(query.YahooIM))
                {
                    QueryParser yahooIMQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.YahooIM, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(yahooIMQueryParser.Parse(query.YahooIM + "*"), BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.QQIM))
            {
                query.QQIM = StringUtilsForLucene.LuceneKeywordsScrubber(query.QQIM.ToLower());
                if (!string.IsNullOrEmpty(query.QQIM))
                {
                    QueryParser qqIMQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.QQIM, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(qqIMQueryParser.Parse(query.QQIM + "*"), BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.SkypeIM))
            {
                query.SkypeIM = StringUtilsForLucene.LuceneKeywordsScrubber(query.SkypeIM.ToLower());
                if (!string.IsNullOrEmpty(query.SkypeIM))
                {
                    QueryParser skypeIMQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.SkypeIM, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(skypeIMQueryParser.Parse(query.SkypeIM + "*"), BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.Mobile))
            {
                query.Mobile = StringUtilsForLucene.LuceneKeywordsScrubber(query.Mobile);
                if (!string.IsNullOrEmpty(query.Mobile))
                {
                    QueryParser mobileQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.Mobile, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(mobileQueryParser.Parse(query.Mobile + "*"), BooleanClause.Occur.MUST);
                }
            }

            if (!string.IsNullOrEmpty(query.PublicEmail))
            {
                query.PublicEmail = StringUtilsForLucene.LuceneKeywordsScrubber(query.PublicEmail.ToLower());
                if (!string.IsNullOrEmpty(query.PublicEmail))
                {
                    QueryParser publicEmailQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.PublicEmail, GetChineseAnalyzerOfUnTokenized());
                    currentQuery.Add(publicEmailQueryParser.Parse(query.PublicEmail + "*"), BooleanClause.Occur.MUST);
                }
            }

            if ((query.SearchRange > 0) && currentUser != null && currentUser.UserType == UserTypes.PersonUser)
            {
                //ֻ֧2
                if (query.SearchRange > 2)
                    query.SearchRange = 2;

                PersonUser pu = (PersonUser)currentUser;
                StringBuilder queryRage = new StringBuilder();

                List<int> toUserIDs = null;
                List<FriendConnectPath> connectPaths = null;
                switch (query.SearchRange)
                {
                    case 1:
                        toUserIDs = Friends.GetFriendUserIDs(pu.UserID);
                        break;
                    case 2:
                        connectPaths = Friends.GetConnectPaths(pu.UserID, 2, false);
                        break;

                    //2
                    //case 3:
                    //    connectPaths = Friends.GetConnectPaths(pu.UserID, 3, false);
                    //    break;
                    default:
                        connectPaths = Friends.GetConnectPaths(pu.UserID, 2, false);
                        break;
                }

                if (toUserIDs == null && connectPaths != null)
                {
                    toUserIDs = new List<int>();
                    for (int i = 0; i < connectPaths.Count; i++)
                    {
                        if (!toUserIDs.Contains(((FriendConnectPath)connectPaths[i]).ToUserID))
                            toUserIDs.Add(((FriendConnectPath)connectPaths[i]).ToUserID);
                    }
                }

                //Ȧδû
                if (toUserIDs.Count == 0)
                {
                    return new SearchResultDataSet<PersonUser>();
                }
                else if (toUserIDs.Count > 0)
                {
                    //ֻʾǰ500
                    for (int i = 0; (i < toUserIDs.Count) && (i < 500); i++)
                    {
                        queryRage.AppendFormat(" {0}", toUserIDs[i].ToString());
                    }

                    QueryParser searchRageQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.UserID, new WhitespaceAnalyzer());
                    queryForFilter.Add(searchRageQueryParser.Parse(queryRage.ToString()), BooleanClause.Occur.MUST);
                }
            }
            else
            {
                //ûܱİ
                Term profileEnableSearchTerm = new Term(PersonUserIndexFields.ProfileEnableSearch, true.ToString().ToLower());
                Query profileEanableSearchQuery = new TermQuery(profileEnableSearchTerm);
                queryForFilter.Add(profileEanableSearchQuery, BooleanClause.Occur.MUST);
            }

            if (query.UpdateDateScope.HasValue)
            {
                Query updatedDateQuery = new TermRangeQuery(PersonUserIndexFields.IndexedDate, DateTools.DateToString(DateTime.Now.AddDays(0 - (int)query.UpdateDateScope.Value), DateTools.Resolution.DAY), DateTools.DateToString(DateTime.Now, DateTools.Resolution.DAY), true, true);
                queryForFilter.Add(updatedDateQuery, BooleanClause.Occur.MUST);
            }

            Filter filter = null;
            if (queryForFilter.Clauses().Count > 0)
                filter = new QueryWrapperFilter(queryForFilter);

            SearchResultDataSet<PersonUser> pds = Search(currentQuery, filter, null, query.PageIndex, query.PageSize);
            return pds;
        }

        //Ӧøĵ÷ʽʵ
        ///// <summary>
        ///// ʶ
        ///// </summary>
        //public SearchResultDataSet<PersonUser> SearchMayKnow(User currentUser, PersonUserFullTextQuery query)
        //{
        //    //ļʱnull
        //    if (!IsIndexFilesExists)
        //        return new SearchResultDataSet<PersonUser>();

        //    if (string.IsNullOrEmpty(query.NowAreaCode) && string.IsNullOrEmpty(query.HomeAreaCode) && string.IsNullOrEmpty(query.School) && string.IsNullOrEmpty(query.CompanyName))
        //        return new SearchResultDataSet<PersonUser>();

        //    BooleanQuery currentQuery = new BooleanQuery();
        //    if (!string.IsNullOrEmpty(query.NowAreaCode))
        //    {
        //        QueryParser nowAreaQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.NowAreaCode, new WhitespaceAnalyzer());

        //        List<Area> childAreas = Areas.GetAllChildAreas(query.NowAreaCode);

        //        string areaIDs = query.NowAreaCode.ToString();

        //        foreach (Area area in childAreas)
        //        {
        //            areaIDs += " " + area.AreaCode;
        //        }

        //        Query nowAreaQuery = nowAreaQueryParser.Parse(areaIDs);

        //        currentQuery.Add(nowAreaQuery, BooleanClause.Occur.SHOULD);
        //    }

        //    if (!string.IsNullOrEmpty(query.HomeAreaCode))
        //    {
        //        QueryParser homeAreaQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.HomeAreaCode, new WhitespaceAnalyzer());

        //        List<Area> childAreas = Areas.GetAllChildAreas(query.HomeAreaCode);

        //        string areaIDs = query.HomeAreaCode.ToString();

        //        foreach (Area area in childAreas)
        //        {
        //            areaIDs += " " + area.AreaCode;
        //        }

        //        Query homeAreaQuery = homeAreaQueryParser.Parse(areaIDs);
        //        currentQuery.Add(homeAreaQuery, BooleanClause.Occur.SHOULD);
        //    }

        //    if (!string.IsNullOrEmpty(query.School))
        //    {
        //        query.School = StringUtilsForLucene.LuceneKeywordsScrubber(query.School);
        //        if (!string.IsNullOrEmpty(query.School))
        //        {
        //            QueryParser schoolQueryParser = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.School, GetChineseAnalyzer());
        //            Query schoolQuery;
        //            if (StringUtilsForLucene.StartsWithLetterOrDigit(query.School))
        //                schoolQuery = schoolQueryParser.Parse(query.School + "*");
        //            else
        //                schoolQuery = schoolQueryParser.Parse(query.School);

        //            currentQuery.Add(schoolQuery, BooleanClause.Occur.SHOULD);
        //        }
        //    }

        //    if (!string.IsNullOrEmpty(query.CompanyName))
        //    {
        //        query.CompanyName = StringUtilsForLucene.CompanyNameScrubber(query.CompanyName);
        //        if (!string.IsNullOrEmpty(query.CompanyName))
        //        {
        //            Query keywordQuery;
        //            keywordQuery = new QueryParser(CurrentLuceneVersion, PersonUserIndexFields.CompanyName, GetChineseAnalyzer()).Parse(query.CompanyName.ToLower());
        //            currentQuery.Add(keywordQuery, BooleanClause.Occur.SHOULD);
        //        }
        //    }


        //    SearchResultDataSet<PersonUser> pds = Search(currentQuery, null, null, query.PageIndex, query.PageSize);
        //    return pds;
        //}
        #endregion

        /// <summary>
        /// ʼ
        /// </summary>
        public override void InitializeIndex(string indexPath)
        {
            #region PersonUser

            if (!System.IO.Directory.Exists(indexPath))
            {
                try
                {
                    System.IO.Directory.CreateDirectory(indexPath);
                }
                catch
                {
                    throw new ApplicationException(string.Format("create Directory '{0}' failed", PhysicalIndexDirectory));
                }
            }

            bool createIndexFile = true;
            int indexPageSize = 2000;
            PersonUserQueryForAdmin query = new PersonUserQueryForAdmin();
            query.AccountStatus = null;
            PagingDataSet<PersonUser> personUserSet = Users.GetPersonUsersForAdmin(query, indexPageSize, 1);
            double tIndex = Convert.ToDouble(personUserSet.TotalRecords) / Convert.ToDouble(indexPageSize);
            int indexPageIndex = (int)Math.Ceiling(tIndex);

            if (personUserSet.TotalRecords > 0)
            {
                //ֶν
                for (int i = 1; i <= indexPageIndex; i++)
                {
                    if (i != 1)
                        personUserSet = Users.GetPersonUsersForAdmin(query, indexPageSize, i);
                    Insert(personUserSet.Records, indexPath, createIndexFile);
                    if (createIndexFile)
                        createIndexFile = false;
                }
            }
            #endregion
        }


        #region Help Methods

        protected override Document ConvertObjToDocument(PersonUser pu)
        {
            Document doc = new Document();
            Field field;
            //pu = Users.ConvertUserForEdit(pu) as PersonUser;
            field = new Field(PersonUserIndexFields.UserID, pu.UserID.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.UserName, pu.UserName.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.CommonName, pu.CommonName.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.NickName, pu.NickName.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Gender, ((int)pu.Gender).ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Birthday, DateTools.DateToString(pu.Birthday, DateTools.Resolution.DAY), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.BirthdayYear, pu.Birthday.Year.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.NowAreaCode, pu.NowAreaCode.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.HomeAreaCode, pu.HomeAreaCode.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Degree, pu.Degree.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.School, pu.School.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Interest, pu.Interest.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Expertise, pu.Expertise.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Title, pu.Title.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.TitleLevel, pu.TitleLevel.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.JobSort, pu.JobSort.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.CompanyName, pu.CompanyName.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.CompanyTrade, pu.CompanyTrade.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.MsnIM, pu.MsnIM.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.YahooIM, pu.YahooIM.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.QQIM, pu.QQIM.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.SkypeIM, pu.SkypeIM.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Mobile, pu.Mobile.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.PublicEmail, pu.PublicEmail.ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Stature, pu.Stature.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Weight, pu.Weight.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Shape, pu.Shape.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Blood, pu.Blood.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.Marriage, pu.Marriage.ToString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.HasAvatar, pu.HasAvatar.ToString().ToLower(), Field.Store.YES, Field.Index.NO);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.IndexedDate, DateTools.DateToString(DateTime.Now, DateTools.Resolution.DAY), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.ProfileEnableSearch, pu.EnableDisplayInMemberList.ToString().ToLower(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);

            field = new Field(PersonUserIndexFields.ProfileIntegrity, (((int)(pu.ProfileIntegrity * 100)).ToString()).PadLeft(3, '0'), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.Add(field);
            ICollection<UserTag> userTags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTags(pu.UserID, true);
            if (userTags != null && userTags.Count > 0)
            {
                foreach (var userTag in userTags)
                {
                    field = new Field(PersonUserIndexFields.Tags, userTag.TagName.ToLower(), Field.Store.YES, Field.Index.ANALYZED);
                    field.SetBoost(2.0F);
                    doc.Add(field);
                }
            }

            return doc;
        }

        protected override PersonUser ConvertDocumentToObj(Document doc)
        {
            PersonUser pu = new PersonUser();
            pu.UserID = int.Parse(doc.Get(PersonUserIndexFields.UserID));
            pu.UserName = doc.Get(PersonUserIndexFields.UserName);
            pu.CommonName = doc.Get(PersonUserIndexFields.CommonName);
            pu.NickName = doc.Get(PersonUserIndexFields.NickName);
            pu.Gender = (Genders)(int.Parse(doc.Get(PersonUserIndexFields.Gender)));
            pu.Birthday = DateTools.StringToDate(doc.Get(PersonUserIndexFields.Birthday));
            pu.NowAreaCode = doc.Get(PersonUserIndexFields.NowAreaCode);
            pu.HomeAreaCode = doc.Get(PersonUserIndexFields.HomeAreaCode);
            pu.Degree = int.Parse(doc.Get(PersonUserIndexFields.Degree));
            pu.School = doc.Get(PersonUserIndexFields.School);
            pu.Interest = doc.Get(PersonUserIndexFields.Interest);
            pu.Expertise = doc.Get(PersonUserIndexFields.Expertise);
            pu.Title = doc.Get(PersonUserIndexFields.Title);
            if (!string.IsNullOrEmpty(doc.Get(PersonUserIndexFields.TitleLevel)))
                pu.TitleLevel = int.Parse(doc.Get(PersonUserIndexFields.TitleLevel));
            pu.JobSort = doc.Get(PersonUserIndexFields.JobSort);
            pu.CompanyName = doc.Get(PersonUserIndexFields.CompanyName);
            pu.CompanyTrade = int.Parse(doc.Get(PersonUserIndexFields.CompanyTrade));

            pu.MsnIM = doc.Get(PersonUserIndexFields.MsnIM);
            pu.YahooIM = doc.Get(PersonUserIndexFields.YahooIM);
            pu.QQIM = doc.Get(PersonUserIndexFields.QQIM);
            pu.SkypeIM = doc.Get(PersonUserIndexFields.SkypeIM);
            pu.Mobile = doc.Get(PersonUserIndexFields.Mobile);
            pu.PublicEmail = doc.Get(PersonUserIndexFields.PublicEmail);
            pu.Stature = int.Parse(doc.Get(PersonUserIndexFields.Stature));
            pu.Weight = int.Parse(doc.Get(PersonUserIndexFields.Weight));
            pu.Shape = int.Parse(doc.Get(PersonUserIndexFields.Shape));
            pu.Blood = int.Parse(doc.Get(PersonUserIndexFields.Blood));
            pu.Marriage = int.Parse(doc.Get(PersonUserIndexFields.Marriage));

            bool hasAvatar = false;
            bool.TryParse(doc.Get(PersonUserIndexFields.HasAvatar), out hasAvatar);
            if (hasAvatar)
                pu.AvatarUrl = "true";

            return pu;
        }

        #endregion

    }
}
