//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// ûıѱ¼ݿ⣬<see cref="SpaceBuilder.LuceneSearch.UserSearch.PersonUserIndexTask"/>µLuceneļ
    /// </summary>
    public class PrepareForUserIndexModule : IGlobalModule
    {
        #region IGlobalModule Members

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.AfterUserChange += new UserEventHandler(gem_PostUserUpdate);
        }

        #endregion

        void gem_PostUserUpdate(User user, GlobalEventArgs e)
        {
            if ((user != null) && (user.UserType == UserTypes.PersonUser) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                ItemForIndex item = new ItemForIndex();
                item.ItemID = user.UserID;
                item.SearchTypeCode = PersonUserSearchTypeSettings.CODE;
                item.DataAction = e.State;
                SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            }
        }

    }
}
