﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.IO;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Common
{
    public class DefaultUrlParser : IUrlParser
    {

        #region IUrlParser 成员

        public void ParseUrl(string url, ref UrlInfo info)
        {
            string extensionName = url.Substring(url.LastIndexOf('.') + 1).Trim().ToLower();


            //判断是不是音频文件地址
            if (SPBConfig.Instance().RadioExtensions.Contains(extensionName))
            {
                info.MediaType = MediaTypes.Music;
                info.Subject = WebUtils.UrlDecode(url.Remove(url.LastIndexOf('.')).Substring(url.LastIndexOf('/') + 1));
                info.PlayUrl = url;
                return;
            }
            //判断是不是视频文件地址
            if (SPBConfig.Instance().VideoExtensions.Contains(extensionName))
            {
                info.Subject = WebUtils.UrlDecode(url.Remove(url.LastIndexOf('.')).Substring(url.LastIndexOf('/') + 1));
                info.MediaType = MediaTypes.Video;
                info.PlayUrl = url;
                return;
            }
            string htmlContent = HttpCollects.GetHTMLContent(url, "</head>");
            if (string.IsNullOrEmpty(htmlContent))
                return;
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            info.MediaType = MediaTypes.Website;
            return;
        }

        #endregion
    }
}