﻿//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Common
{
    public class Ku6UrlParser : IUrlParser
    {
        #region IUrlParser 成员

        public void ParseUrl(string url, ref UrlInfo info)
        {
            info.PlayUrl = GetPlayerUrlString(url);//修改url为播放器地址
            info.MediaType = MediaTypes.Video;
            string endreg = "id=\"commentList\"";
            string htmlContent = HttpCollects.GetHTMLContent(url, endreg);
            if (string.IsNullOrEmpty(htmlContent))
            {
                return;
            }
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            info.ThumbnailUrl = GetThumbnailUrlString(htmlContent, true);
            return;
        }

        #endregion IUrlParser 成员

        /// <summary>
        /// 修改url为播放器地址
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public string GetPlayerUrlString(string url)
        {
            string regString = @"^http://(my|v).ku6.com/((show[\w_]*/(?<getcontent>[\w-_.]+))|(special/show_([\d]+)/(?<getcontent>[\w-_.]+))|(watch\?v=(?<getcontent>[\w._-]+)))(#share|html)$";
            string playerFormat = @"http://player.ku6.com/refer/{0}/v.swf&auto=1";

            Regex regex = new Regex(regString, RegexOptions.IgnoreCase);
            Match match = regex.Match(url);
            if (match.Success)
            {
                return string.Format(playerFormat, match.Groups["getcontent"].Value.Replace("...", ".."));
            }
            else
            {
                return url;
            }
        }

        /// <summary>
        /// 获取缩略图地址
        /// </summary>
        /// <param name="html">html页面文档</param>
        /// <param name="ignoreCase"></param>
        /// <returns></returns>
        public string GetThumbnailUrlString(string html, bool ignoreCase)
        {
            string regString = "((\"cover\")|(cover)|(cover\\s)):(\\s)?\"((?<thumbnailUrl>(http:((//)|([\\\\/]+)))?img[0-9]?.c2.ku6.cn[0-9a-zA-Z\\/_]*.jpg)|(?<thumbnailUrl>(http:((//)|([\\\\/]+)))?(i|vi)[0-9]?.ku6img.com[0-9a-zA-Z\\\\/_]*.jpg))\"";
            Regex reg;
            if (ignoreCase)
                reg = new Regex(regString, RegexOptions.IgnoreCase);
            else
                reg = new Regex(regString);

            Match match = reg.Match(html);

            if (match.Success)
            {
                if (match.Groups["thumbnailUrl"].Value.Contains("http"))
                {
                    return match.Groups["thumbnailUrl"].Value.Replace("\\", string.Empty);
                }
                else
                {
                    return "http://" + match.Groups["thumbnailUrl"].Value.Replace("\\", string.Empty);
                }
            }

            return string.Empty;
        }
    }
}