﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Common
{
    public class RadioDefaultUrlParser : IUrlParser
    {
        #region IUrlParser 成员

        public void ParseUrl(string url,ref UrlInfo info)
        {
            if (url.EndsWith("/"))
                url = url.Remove(url.Length - 1, 1);
            string extensionName = url.Substring(url.LastIndexOf('.') + 1).Trim().ToLower();
            //判断是不是音频文件地址
            if (SPBConfig.Instance().RadioExtensions.Contains(extensionName))
            {
                info.MediaType = MediaTypes.Music;
                //resource.Subject = WebUtils.UrlDecodePathComponent(url.Substring(url.LastIndexOf('/') + 1));
                //resource.Subject = resource.Subject.Remove(resource.Subject.LastIndexOf('.'));
                info.Subject = WebUtils.UrlDecode(url.Remove(url.LastIndexOf('.')).Substring(url.LastIndexOf('/') + 1));
                info.PlayUrl = url;
                return;
            }
            string htmlContent = HttpCollects.GetHTMLContent(url, "</head>");
            if (string.IsNullOrEmpty(htmlContent))
                return;
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            return;
        }

        #endregion

    }
}
