﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace SpaceBuilder.Common
{
    public class SixRoomUrlParser : IUrlParser
    {
        #region IUrlParser 成员

        public void ParseUrl(string url,ref UrlInfo info)
        {
            string htmlContent = HttpCollects.GetHTMLContent(url);
            if (string.IsNullOrEmpty(htmlContent))
            {
                return;
            }
            info.PlayUrl = GetPlayerUrlString(htmlContent, url);//从页面里获取播放器地址  
            info.MediaType = MediaTypes.Video;
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            info.ThumbnailUrl = GetThumbnailUrlString(htmlContent, true);
            return;
        }

        #endregion

        /// <summary>
        /// 从页面里获取播放器地址
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public string GetPlayerUrlString(string html, string url)
        {
            string playerFormat = @"&quot;http://6.cn/p/(?<getcontent>[a-zA-Z\d\/_]+).swf&quot";

            Regex regex = new Regex(playerFormat, RegexOptions.IgnoreCase);
            Match match = regex.Match(html);
            if (match.Success)
            {
                return string.Format("http://6.cn/p/{0}.swf&flag=1", match.Groups["getcontent"].Value);
            }
            else
            {
                return url;
            }
        }

        /// <summary>
        /// 获取缩略图地址
        /// </summary>
        /// <param name="html">html页面文档</param>
        /// <param name="ignoreCase"></param>
        /// <returns></returns>
        public string GetThumbnailUrlString(string html, bool ignoreCase)
        {
            string regString = "class=\"summary\"><img src=\"http://(?<getcontent>[a-zA-Z\\d\\/.]+)";
            Regex reg;
            if (ignoreCase)
            {
                reg = new Regex(regString, RegexOptions.IgnoreCase);
            }
            else
            {
                reg = new Regex(regString);
            }
            Match match = reg.Match(html);
            if (match.Success)
            {
                return string.Format("http://{0}", match.Groups["getcontent"].Value);
            }
            else
            {
                return string.Empty;
            }
        }
    }
}
