﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace SpaceBuilder.Common
{
    public class SohuUrlParser : IUrlParser
    {
        #region IUrlParser 成员

        string content;
        public void ParseUrl(string url, ref UrlInfo info)
        {


            info.MediaType = MediaTypes.Video;
            string htmlContent = HttpCollects.GetHTMLContent(url);
            if (string.IsNullOrEmpty(htmlContent))
            {
                return;
            }
            info.PlayUrl = GetPlayerUrlString(htmlContent, url);
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            info.ThumbnailUrl = GetThumbnailUrlString(htmlContent, true);
            return;
        }

        #endregion

        /// <summary>
        /// 修改url为播放器地址
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public string GetPlayerUrlString(string html, string url)
        {
            string regString = @"http://share.vrs.sohu.com/my/v.swf&topBar=1&id=\d*";

            Regex regex = new Regex(regString, RegexOptions.IgnoreCase);
            Match match = regex.Match(html);

            if (match.Success)
                return match.Value + "&skinNum=2";

            string regString2 = "var vid=\"(?<getvid>\\d+)\";";
            regex = new Regex(regString2, RegexOptions.IgnoreCase);
            match = regex.Match(html);
            if (match.Success)
            {
                string vid = match.Groups["getvid"].Value;
                return string.Format("http://share.vrs.sohu.com/{0}/v.swf&autoplay=false", vid);
            }

            return url;
        }

        /// <summary>
        /// 获取缩略图地址
        /// </summary>
        /// <param name="html">html页面文档</param>
        /// <param name="ignoreCase"></param>
        /// <returns></returns>
        public string GetThumbnailUrlString(string html, bool ignoreCase)
        {
            string regString = string.Format(@"http://201.img.pp.sohu.com.cn/images/video/(?<getleft>[a-zA-Z\d\/_]+){0}(?<getright>[a-zA-Z\d_]+).jpg", content);
            Regex reg;
            if (ignoreCase)
            {
                reg = new Regex(regString, RegexOptions.IgnoreCase);
            }
            else
            {
                reg = new Regex(regString);
            }
            Match match = reg.Match(html);
            if (match.Success)
            {
                return string.Format("http://201.img.pp.sohu.com.cn/images/video/{0}{1}{2}.jpg", match.Groups["getleft"].Value, content, match.Groups["getright"].Value);
            }
            else
            {
                return string.Empty;
            }
        }
    }
}
