﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Common
{
    public class VideoDefaultUrlParser : IUrlParser
    {
        #region IUrlParser 成员

        public void ParseUrl(string url,ref UrlInfo info)
        {
            if (url.EndsWith("/"))
                url = url.Remove(url.Length - 1, 1);
            string extensionName = url.Substring(url.LastIndexOf('.') + 1).Trim().ToLower();
            //判断是不是视频文件地址
            if (SPBConfig.Instance().VideoExtensions.Contains(extensionName))
            {
                //resource.Subject = WebUtils.UrlDecode(url.Substring(url.LastIndexOf('/') + 1).Remove(url.LastIndexOf('.')));
                info.Subject = WebUtils.UrlDecode(url.Remove(url.LastIndexOf('.')).Substring(url.LastIndexOf('/') + 1));
                info.MediaType = MediaTypes.Video;
                info.PlayUrl = url;
                return;
            }
            string htmlContent = HttpCollects.GetHTMLContent(url, "</head>");
            if (string.IsNullOrEmpty(htmlContent))
                return;
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            return;
        }

        #endregion

    }
}