﻿//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace SpaceBuilder.Common
{
    public class YoukuUrlParser : IUrlParser
    {
        #region IUrlParser 成员

        public void ParseUrl(string url, ref UrlInfo info)
        {
            info.PlayUrl = GetPlayerUrlString(url);//修改url为播放器地址
            info.MediaType = MediaTypes.Video;
            string htmlContent = HttpCollects.GetHTMLContent(url);
            if (string.IsNullOrEmpty(htmlContent))
                return;
            info.Subject = HttpCollects.GetTitle(htmlContent, true);
            info.Body = HttpCollects.GetDescription(htmlContent, true);
            info.ThumbnailUrl = GetThumbnailUrlString(htmlContent, true);
            return;
        }

        #endregion IUrlParser 成员

        public string GetPlayerUrlString(string url)
        {
            string regString = @"^http://v.youku.com/v_show/id_(?<getcontent>[a-zA-Z\d=]+).html$";
            string playerFormat = @"http://player.youku.com/player.php/sid/{0}&isAutoPlay=true/v.swf";

            Regex regex = new Regex(regString, RegexOptions.IgnoreCase);
            Match match = regex.Match(url);
            if (match.Success)
                return string.Format(playerFormat, match.Groups["getcontent"].Value);
            else
                return url;
        }

        public string GetThumbnailUrlString(string html, bool ignoreCase)
        {
            string regString = "//(?<getcontent1>[\\w]+)\\.ykimg.com/(?<getcontent2>[\\w-]+)";
            Regex reg;
            if (ignoreCase)
            {
                reg = new Regex(regString, RegexOptions.IgnoreCase);
            }
            else
            {
                reg = new Regex(regString);
            }
            Match match = reg.Match(html);
            if (match.Success)
                return string.Format("http://{0}.ykimg.com/{1}", match.Groups["getcontent1"].Value, match.Groups["getcontent2"].Value);
            else
                return string.Empty;
        }
    }
}