//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Web;
using SpaceBuilder.Utils;
using System.Collections;
using System.Collections.Generic;
namespace SpaceBuilder.Common
{
    /// <summary>
    /// ûCookieд
    /// </summary>
    public class UserCookie
    {
        #region Instance

        string cookieName;
        HttpContextBase httpContextBase = null;
        HttpContext httpContext = null;

        /// <summary>
        /// 캯
        /// </summary>
        public UserCookie(User user, HttpContextBase _httpContextBase)
        {
            httpContextBase = _httpContextBase;

            //Allows different users on the same machine
            //ҳûCookieʹõjs ֱдģ "SpaceBuilder-UserCookie"
            cookieName = "SpaceBuilder-UserCookie:" + (user != null ? user.UserID.ToString() : "0");
            cookie = httpContextBase.Request.Cookies[cookieName];

            if (cookie == null)
                cookie = new HttpCookie(cookieName);
            else
                cookie = httpContextBase.Request.Cookies[cookieName];
        }

        /// <summary>
        /// 캯
        /// </summary>
        public UserCookie(User user, HttpContext _httpContext)
        {
            httpContext = _httpContext;

            //Allows different users on the same machine
            //ҳûCookieʹõjs ֱдģ "SpaceBuilder-UserCookie"
            int userID = (user != null ? user.UserID : 0);
            cookieName = "SpaceBuilder-UserCookie:" + userID;
            cookie = httpContext.Request.Cookies[cookieName];

            if (cookie == null)
                cookie = new HttpCookie(cookieName);
            else
                cookie = httpContext.Request.Cookies[cookieName];
        }

        #endregion

        #region Member variables and constructor

        /// <summary>
        /// ûCookie
        /// </summary>
        private HttpCookie cookie;
        public HttpCookie Cookie
        {
            get { return this.cookie; }
            set { this.cookie = value; }
        }

        #endregion

        #region ̳Ƥ

        ///// <summary>
        ///// ̳
        ///// </summary>
        ///// <param name="themeName"></param>
        //public void SaveForumThemeName(string themeName)
        //{
        //    if (Cookie != null)
        //    {
        //        Cookie["ForumThemeName"] = themeName;
        //        WriteCookie();
        //    }
        //}

        ///// <summary>
        ///// ȡ̳
        ///// </summary>
        //public string GetForumThemeName()
        //{
        //    if (Cookie != null)
        //        return Cookie["ForumThemeName"];
        //    else
        //        return string.Empty;
        //}

        /// <summary>
        /// ̳Ƥ
        /// </summary>
        /// <param name="themeAppearanceKey"></param>
        public void SaveForumThemeAppearance(string themeAppearanceName)
        {
            if (Cookie != null)
            {
                Cookie["ForumThemeAppearance"] = themeAppearanceName;
                WriteCookie();
            }
        }

        /// <summary>
        /// ȡ̳Ƥ
        /// </summary>
        public string GetForumThemeAppearance()
        {
            if (Cookie != null)
                return Cookie["ForumThemeAppearance"];
            else
                return string.Empty;
        }

        #endregion

        #region RememberMe

        private readonly string RememberMeInforCookie_name = "RememberMeName";
        private readonly string RememberMeInforCookie_url = "RememberMeUrl";

        /// <summary>
        /// Ϣûƣ
        /// </summary>
        public void SaveRememberMeInfor_name(string rememberMyName)
        {
            if (cookie != null)
            {
                cookie[RememberMeInforCookie_name] = HttpUtility.UrlEncode(rememberMyName);
                WriteCookie();
            }
        }

        /// <summary>
        /// Ϣûӣ
        /// </summary>
        public void SaveRememberMeInfor_url(string rememberMyUrl)
        {
            if (cookie != null)
            {
                cookie[RememberMeInforCookie_url] = HttpUtility.UrlEncode(rememberMyUrl);
                WriteCookie();
            }
        }

        /// <summary>
        /// ȡϢû
        /// </summary>
        public string GetRememberMeInfor_name()
        {
            string information = ResourceManager.GetString("Common_AnonymousDisplayName");
            if (cookie != null)
            {
                information = HttpUtility.UrlDecode(Convert.ToString(cookie[RememberMeInforCookie_name]));
            }

            return information;
        }

        /// <summary>
        /// ȡϢûӣ
        /// </summary>
        public string GetRememberMeInfor_url()
        {
            string information = string.Empty;
            if (cookie != null)
            {
                information = HttpUtility.UrlDecode(Convert.ToString(cookie[RememberMeInforCookie_url]));
            }

            return information;
        }


        #endregion

        #region Ķ״̬
        private readonly string ReadedAnnouncementIDsCookieKey = "ReadedAnnouncementIDs";
        /// <summary>
        /// ѶĹб
        /// </summary>      
        public void SaveReadedAnnouncementIDs(int threadID)
        {
            if (cookie != null)
            {
                string oldThreadIDs = cookie[ReadedAnnouncementIDsCookieKey];
                cookie[ReadedAnnouncementIDsCookieKey] = oldThreadIDs + threadID.ToString() + ",";
                WriteCookie();
            }
        }
        /// <summary>
        /// ȡѶĹб
        /// </summary>
        public IList<int> GetReadedAnnouncementIDs()
        {
            string informattion = string.Empty;
            IList<int> IDs = new List<int>();
            if (cookie[ReadedAnnouncementIDsCookieKey] != null)
            {
                informattion = cookie[ReadedAnnouncementIDsCookieKey];
                if (informattion.Length > 0)
                {
                    string[] ids = informattion.Split(',');
                    foreach (string item in ids)
                    {
                        int key;
                        int.TryParse(item, out key);
                        if (key > 0)
                            IDs.Add(key);
                    }
                }
                return IDs;

            }
            return IDs;
        }
        #endregion

        #region LanguageCode

        private readonly string LanguageCodeCookie = "LanguageCode";

        /// <summary>
        /// ûʹ
        /// </summary>
        public void SaveLanguageCode(string languageCode)
        {
            if (cookie != null)
            {
                cookie[LanguageCodeCookie] = HttpUtility.UrlEncode(languageCode);
                WriteCookie();
            }
        }

        /// <summary>
        /// ȡûʹ
        /// </summary>
        public string GetLanguageCode()
        {
            if (cookie != null && cookie[LanguageCodeCookie] != null)
            {
                return HttpUtility.UrlDecode(Convert.ToString(cookie[LanguageCodeCookie]));
            }
            return SiteSettingsManager.GetSiteSettings().DefaultLanguage;
        }

        #endregion



        #region Private helper methods

        /// <summary>
        /// дcookie
        /// </summary>
        /// <remarks>cookieʱΪ1</remarks>
        public void WriteCookie()
        {
            cookie.Expires = DateTime.Now.AddYears(1);

            if (httpContextBase != null)
                httpContextBase.Response.Cookies.Add(cookie);
            else if (httpContext != null)
                httpContext.Response.Cookies.Add(cookie);
        }
        #endregion

    }
}
