//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// ʱûʱת
    /// </summary>
    public static class UserTime
    {
        ///<overloads>תûʱ</overloads>
        /// <summary>
        /// תûʱ
        /// </summary>
        public static DateTime ConvertToUserTime(DateTime dt, double ClientTimeZone)
        {
            return dt.AddHours(FromClientToServerFactor(ClientTimeZone, SiteSettingsManager.GetSiteSettings().SiteTimezone));
        }
        
        /// <summary>
        /// תûʱ
        /// </summary>
        public static DateTime ConvertToUserTime(DateTime dt)
        {
            return dt.AddHours(FromClientToServerFactor(Globals.GetCurrentUser().Timezone, SiteSettingsManager.GetSiteSettings().SiteTimezone));
        }

        /// <summary>
        /// תɷʱ
        /// </summary>
        public static DateTime ConvertToServerTime(DateTime dt, double ClientTimeZone)
        {
            return dt.AddHours(FromServerToClientFactor(ClientTimeZone, SiteSettingsManager.GetSiteSettings().SiteTimezone));
        }

        /// <summary>
        /// תɷʱ
        /// </summary>
        public static DateTime ConvertToServerTime(DateTime dt)
        {
            return dt.AddHours(FromServerToClientFactor(Globals.GetCurrentUser().Timezone, SiteSettingsManager.GetSiteSettings().SiteTimezone));
        }

        /// <summary>
        /// ûڵصǰʱ
        /// </summary>
        public static DateTime CurrentUserTime
        {
            get
            {
                if (Globals.GetCurrentUser() == null)
                    return DateTime.Now;

                return DateTime.Now.AddHours(ClientToServerTimeZoneFactor);
            }
        }

        /// <summary>
        /// ǰʱ
        /// </summary>
        public static DateTime CurrentServerTime
        {
            get { return DateTime.Now; }
        }

        #region helpers

        /// <summary>
        /// Returns the TimeZone factor for the current user
        /// </summary>
        private static double ClientToServerTimeZoneFactor
        {
            get
            {
                return FromClientToServerFactor(Globals.GetCurrentUser().Timezone, SiteSettingsManager.GetSiteSettings().SiteTimezone);
            }
        }

        private static double FromClientToServerFactor(double Client, double Server)
        {
            return Client - Server;
        }

        private static double FromServerToClientFactor(double Client, double Server)
        {
            return Server - Client;
        }

        /// <summary>
        /// Returns the TimeZone factor the server compared to the current user
        /// </summary>
        private static double ServerToClientTimeZoneFactor
        {
            get
            {
                User currentUser = Globals.GetCurrentUser();
                return FromServerToClientFactor(currentUser.Timezone, SiteSettingsManager.GetSiteSettings().SiteTimezone);
            }
        }
        #endregion
    }
}
