﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 生成面包屑
    /// </summary>
    public class BreadCrumb : Control
    {
        /// <summary>
        /// BreadCrumbQueue在HttpContext.Items中的key
        /// </summary>
        static readonly string BreadCrumbKeyInHttpContext = "BreadCrumbQueue";

        protected override void Render(HtmlTextWriter writer)
        {
            Queue<TagBuilder> crumbNodes = Context.Items[BreadCrumbKeyInHttpContext] as Queue<TagBuilder>;

            if (crumbNodes != null && crumbNodes.Count > 0)
            {
                //输出PageName
                if (crumbNodes.Count == 1)
                {
                    writer.Write("<div class=\"tn-pagename\">");
                    TagBuilder a = crumbNodes.Dequeue();
                    writer.Write(string.Format("<h1 class=\"tn-helper-reset tn-text-heading\">{0}</h1>", a.InnerHtml));
                    writer.Write("</div>");
                    return;
                }
                writer.Write("<div class=\"tn-breadcrumb\">");
                if (isAutoAddSiteHomeNode)
                    writer.Write(string.Format("<span class=\"tn-breadcrumb-item\"><a href=\"{0}\"><span>{1}</span></a></span>", SiteUrls.Instance().Home(), ResourceManager.GetString("Navigation_SiteHome")));
                else if (crumbNodes.Count > 0) //将第一个节点作为首页
                {
                    TagBuilder a = crumbNodes.Dequeue();
                    a.MergeAttribute("title", HtmlUtils.TrimHtml(a.InnerHtml, NodeMaxLength));
                    writer.Write(string.Format("<span class=\"tn-breadcrumb-item\">{0}</span>", a.ToString()));
                }
                while (crumbNodes.Count > 0)
                {
                    writer.Write("<span class=\"tn-seperator\">&gt;</span>");
                    TagBuilder a = crumbNodes.Dequeue();
                    if (!RenderLastNodeAsLink && crumbNodes.Count == 0 || string.IsNullOrEmpty(a.Attributes["href"]))
                        writer.Write(string.Format("<span class=\"tn-breadcrumb-item\">{0}</span>", a.InnerHtml));
                    else
                    {
                        // add title for hover over
                        a.MergeAttribute("title", HtmlUtils.TrimHtml(a.InnerHtml, NodeMaxLength));

                        writer.Write(string.Format("<span class=\"tn-breadcrumb-item\">{0}</span>", a.ToString()));
                    }
                }
                writer.Write("</div>");
            }
            else
            {
                this.Visible = false;
            }
        }

        private bool renderLastNodeAsLink = false;
        /// <summary>
        /// 最后一个节点是否呈现为链接
        /// </summary>
        public bool RenderLastNodeAsLink
        {
            get { return renderLastNodeAsLink; }
            set { renderLastNodeAsLink = value; }
        }


        private int nodeMaxLength = 30;
        /// <summary>
        /// 面包屑节点的字符串最大长度
        /// </summary>
        public int NodeMaxLength
        {
            get { return nodeMaxLength; }
            set { nodeMaxLength = value; }
        }
        private bool isAutoAddSiteHomeNode = false;
        /// <summary>
        /// 是否自动添加站点首页节点
        /// </summary>
        public bool IsAutoAddSiteHomeNode
        {
            get { return isAutoAddSiteHomeNode; }
            set { isAutoAddSiteHomeNode = value; }
        }


        #region 静态成员

        /// <summary>
        /// 添加面包屑节点
        /// </summary>
        public static void AddBreadCrumbItem(string innerHtml, string href)
        {
            Queue<TagBuilder> crumbNodes = HttpContext.Current.Items[BreadCrumbKeyInHttpContext] as Queue<TagBuilder>;

            if (crumbNodes == null)
            {
                crumbNodes = new Queue<TagBuilder>();
                HttpContext.Current.Items[BreadCrumbKeyInHttpContext] = crumbNodes;
            }

            TagBuilder anchor = new TagBuilder("a");
            anchor.InnerHtml = innerHtml;
            anchor.MergeAttribute("href", href);
            crumbNodes.Enqueue(anchor);
        }

        #endregion


    }
}
