﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.ComponentModel;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 内容块
    /// </summary>
    [ParseChildren(true), PersistChildren(false)]
    public class ContentModule : Control, INamingContainer
    {
        private ITemplate titleTemplate;
        /// <summary>
        /// 标题模板
        /// </summary>
        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty)
        ]
        public ITemplate TitleTemplate
        {
            get { return titleTemplate; }
            set { titleTemplate = value; }
        }


        private ITemplate contentTemplate;
        /// <summary>
        /// 内容模板
        /// </summary>
        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty)
        ]
        public ITemplate ContentTemplate
        {
            get { return contentTemplate; }
            set { contentTemplate = value; }
        }

        private ITemplate bottomTemplate;
        /// <summary>
        /// 底部模板
        /// </summary>
        [
        Browsable(false),
        PersistenceMode(PersistenceMode.InnerProperty)
        ]
        public ITemplate BottomTemplate
        {
            get { return bottomTemplate; }
            set { bottomTemplate = value; }
        }

        protected override void Render(HtmlTextWriter writer)
        {
            writer.WriteBeginTag("div");
            if (!string.IsNullOrEmpty(ID))
                writer.WriteAttribute("id", ID);

            writer.WriteAttribute("class", "module");
            writer.Write('>');

            HtmlGenericControl titleContainer = new HtmlGenericControl("div");
            titleContainer.Attributes["class"] = "moduleTitle";
            if (TitleTemplate != null)
                TitleTemplate.InstantiateIn(titleContainer);

            titleContainer.RenderControl(writer);

            HtmlGenericControl contentContainer = new HtmlGenericControl("div");
            contentContainer.Attributes["class"] = "moduleContent";
            if (ContentTemplate != null)
                ContentTemplate.InstantiateIn(contentContainer);

            contentContainer.RenderControl(writer);

            if (BottomTemplate != null)
            {
                HtmlGenericControl bottomContainer = new HtmlGenericControl("div");
                bottomContainer.Attributes["class"] = "moduleBottom";
                BottomTemplate.InstantiateIn(bottomContainer);

                bottomContainer.RenderControl(writer);
            }

            writer.WriteEndTag("div");
        }


    }    
    
}
