﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Routing;
using System.Web.Mvc;
using SpaceBuilder.Common;
using System.Linq;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 辅助广告相关呈现
    /// </summary>
    public partial class SPBHtmlHelper
    {
        /// <summary>
        /// 在频道中显示广告
        /// </summary>
        /// <param name="positionCode">广告位编码</param>
        /// <param name="htmlAttributes">html属性，例如：new{Class="dropDownList",id="SortOrderSelect"}</param>
        public string ShowAdvertisingInChannel(string positionCode, RouteValueDictionary htmlAttributes)
        {
            return ShowAdvertising(PresentAreaIDs.Instance().Channel(), positionCode, null, htmlAttributes);
        }

        /// <summary>
        /// 在空间中显示广告
        /// </summary>
        /// <param name="positionCode">广告位编码</param>
        /// <param name="htmlAttributes">html属性，例如：new{Class="dropDownList",id="SortOrderSelect"}</param>
        public string ShowAdvertisingInUserDomain(string positionCode, string userDomainName, RouteValueDictionary htmlAttributes)
        {
            return ShowAdvertising(PresentAreaIDs.Instance().UserDomain(), positionCode, userDomainName, htmlAttributes);
        }

        /// <summary>
        /// 在群组中显示广告
        /// </summary>
        /// <param name="positionCode">广告位编码</param>
        /// <param name="htmlAttributes">html属性，例如：new{Class="dropDownList",id="SortOrderSelect"}</param>
        public string ShowAdvertisingInClubDomain(string positionCode, string clubDomainName, RouteValueDictionary htmlAttributes)
        {
            return ShowAdvertising(PresentAreaIDs.Instance().ClubDomain(), positionCode, clubDomainName, htmlAttributes);
        }

        /// <summary>
        /// 显示广告位的广告
        /// </summary>
        /// <param name="presentAreaID">广告位类别</param>
        /// <param name="positionCode">广告位编码</param>
        /// <param name="domainName">UserDomainName 或者 ClubDomainName</param>
        /// <param name="htmlAttributes">html属性，例如：new RouteValueDictionary{"Class","dropDownList"},{"id","SortOrderSelect"}}</param>
        private static string ShowAdvertising(int presentAreaID, string positionCode, string domainName, RouteValueDictionary htmlAttributes)
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
            if (siteSettings.EnableAD)
            {
                int ownerID = 0;
                if (presentAreaID == PresentAreaIDs.Instance().UserDomain())
                {
                    User owner = Users.GetUser(domainName, false);
                    if (owner != null)
                        ownerID = owner.UserID;
                }
                else if (presentAreaID == PresentAreaIDs.Instance().ClubDomain())
                {
                    SpaceBuilder.Club.Club owner = SpaceBuilder.Club.Clubs.GetClub(domainName, false);
                    if (owner != null)
                        ownerID = owner.ClubID;
                }

                if (ownerID == 0 && (presentAreaID == PresentAreaIDs.Instance().UserDomain() || presentAreaID == PresentAreaIDs.Instance().ClubDomain()))
                    return string.Empty;

                AdvertisingPosition adPosition = Advertisings.GetAdvertisingPosition(positionCode, false);
                if (adPosition == null)
                    return string.Empty;

                IList<Advertising> advertisingList;

                if (presentAreaID == PresentAreaIDs.Instance().Channel())
                    advertisingList = Advertisings.GetAdvertisingsOfPosition(positionCode);
                else
                    advertisingList = Advertisings.GetAdvertisingsOfPosition(positionCode, ownerID, true, false);

                if (advertisingList != null && advertisingList.Count > 0)
                {
                    StringBuilder sbADContent = new StringBuilder();

                    // 多个广告间的分隔符        
                    string AdvertisingSeparator = "";

                    for (int i = 0; i < advertisingList.Count; i++)
                    {
                        Advertising advertising = advertisingList[i];

                        if (advertising != null)
                        {
                            if (DateTime.Now < advertising.EffectiveDateFrom || DateTime.Now > advertising.EffectiveDateTo || !advertising.IsEnabled)
                                continue;

                            if (i > 0)
                                sbADContent.Append(AdvertisingSeparator);

                            switch (advertising.AdvertisingType)
                            {
                                case AdvertisingTypes.Script:
                                default:
                                    sbADContent.Append(advertising.Script).Append("\r\n");
                                    break;
                            }
                        }
                    }

                    if (sbADContent.Length > 0)
                    {
                        TagBuilder adContainer = new TagBuilder("div");
                        adContainer.MergeAttribute("id", "SP-" + positionCode);
                        //adContainer.AddCssClass(CssClass);
                        if (htmlAttributes != null)
                            adContainer.MergeAttributes(htmlAttributes);

                        adContainer.InnerHtml = sbADContent.ToString();

                        return adContainer.ToString(TagRenderMode.Normal);
                    }
                }
            }

            return string.Empty;
        }
    }
}
