﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {
        /// <summary>
        /// 显示性别
        /// </summary>        
        public string ShowGender(Genders gender)
        {
            switch (gender)
            {
                case Genders.All:
                    return "不限";
                case Genders.Female:
                    return "女";
                case Genders.Male:
                    return "男";
                default:
                    return string.Empty;
            }
        }

        /// <summary>
        /// 显示行业
        /// </summary>
        public string ShowTrade(int trade)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade());
            if (dictionary.ContainsKey(trade))
                return dictionary[trade].GetMultilingualName(Globals.GetCurrentUserLanguage());

            return string.Empty;
        }

        /// <summary>
        /// 显示学历
        /// </summary>
        public string ShowDegree(int degree)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Degree());
            if (dictionary.ContainsKey(degree))
                return dictionary[degree].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示体型
        /// </summary>
        public string ShowShape(int shape)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Shape());
            if (dictionary.ContainsKey(shape))
                return dictionary[shape].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示目前状况
        /// </summary>
        public string ShowNowStatus(int nowStatus)
        {
            switch (nowStatus)
            {
                case 3:
                    return "求学中";
                case 2:
                    return "在职中";
                case 1:
                    return "求职中";
                default:
                    return "求职中";

            }
        }

        /// <summary>
        /// 显示血型
        /// </summary>
        public string ShowBlood(int blood)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Blood());
            if (dictionary.ContainsKey(blood))
                return dictionary[blood].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示抽烟情况
        /// </summary>
        public string ShowSmoke(int smoke)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Smoke());
            if (dictionary.ContainsKey(smoke))
                return dictionary[smoke].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示喝酒情况
        /// </summary>
        public string ShowDrink(int drink)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Drink());
            if (dictionary.ContainsKey(drink))
                return dictionary[drink].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示婚姻状况
        /// </summary>
        public string ShowMarriage(int marriage)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Marriage());
            if (dictionary.ContainsKey(marriage))
                return dictionary[marriage].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示健康状况
        /// </summary>
        public string ShowHealth(int health)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Health());
            if (dictionary.ContainsKey(health))
                return dictionary[health].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示朋友间的亲密程度
        /// </summary>
        public string ShowFriendliness(int friendliness)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Friendliness());
            if (dictionary.ContainsKey(friendliness))
                return dictionary[friendliness].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示身份识别卡的类型
        /// </summary>
        public string ShowCardType(int cardType)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().CardType());
            if (dictionary.ContainsKey(cardType))
                return dictionary[cardType].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示企业性质
        /// </summary>
        public string ShowCompanyProperty(int companyProperty)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().CompanyProperty());
            if (dictionary.ContainsKey(companyProperty))
                return dictionary[companyProperty].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示雇员数量分类
        /// </summary>
        public string ShowEmployeeCount(int employeeCount)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().EmployeeCount());
            if (dictionary.ContainsKey(employeeCount))
                return dictionary[employeeCount].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示注册资金分类
        /// </summary>
        public string ShowFund(int fund)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Fund());
            if (dictionary.ContainsKey(fund))
                return dictionary[fund].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示工资待遇
        /// </summary>
        public string ShowSalary(int salary)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Salary());
            if (dictionary.ContainsKey(salary))
                return dictionary[salary].GetMultilingualName(Globals.GetCurrentUserLanguage()) + "元";
            return string.Empty;
        }

        /// <summary>
        /// 专业类别
        /// </summary>
        public string MajorSort(int majorSort)
        {
            if (majorSort > 0)
                return "不限";
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().MajorSort());
            if (!dictionary.ContainsKey(majorSort))
                return string.Empty;
            return (string)dictionary[majorSort].GetMultilingualName(Globals.GetCurrentUserLanguage());
        }

        /// <summary>
        /// 显示公司规模
        /// </summary>
        public string ShowEmployee(int employeeNum)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().EmployeeCount());
            if (dictionary.ContainsKey(employeeNum))
                return dictionary[employeeNum].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示语言类型
        /// </summary>
        public string ShowLanguage(int language)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().Language());
            if (dictionary.ContainsKey(language))
                return dictionary[language].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示语言掌握情况
        /// </summary>
        public string ShowLevelForLan(int LevelForLan)
        {
            switch (LevelForLan)
            {
                case 0:
                    return "未填";
                case 1:
                    return "较差";
                case 2:
                    return "一般";
                case 3:
                    return "良好";
                case 4:
                    return "熟练";
                case 5:
                    return "精通";
                default:
                    return string.Empty;
            }



        }


        /// <summary>
        /// 显示英语等级
        /// </summary>
        public string ShowEnglishGrade(int englishGrade)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().EnglishGrade());
            if (dictionary.ContainsKey(englishGrade))
                return dictionary[englishGrade].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示专业类别
        /// </summary>
        public string ShowMajorSort(int majorSort)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().MajorSort());
            if (dictionary.ContainsKey(majorSort))
                return dictionary[majorSort].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示职务等级
        /// </summary>
        public string ShowTitleLevel(int titleLevel)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().TitleLevel());
            if (dictionary.ContainsKey(titleLevel))
                return dictionary[titleLevel].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示日期范围
        /// </summary>
        public string ShowDateScope(int dateScope)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().DateScope());
            if (dictionary.ContainsKey(dateScope))
                return dictionary[dateScope].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示用户级别类型
        /// </summary>
        public string ShowUserRankType(int userRankType)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().UserRankType());
            if (dictionary.ContainsKey(userRankType))
                return dictionary[userRankType].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示时区
        /// </summary>
        public string ShowTimeZone(int timeZone)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().TimeZone());
            if (dictionary.ContainsKey(timeZone))
                return dictionary[timeZone].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }

        /// <summary>
        /// 显示有效期
        /// </summary>
        public string ShowActiveDate(int activeDate)
        {
            Dictionary<int, CodeItem> dictionary = CodeItems.GetCodeItems(CodeSetCodes.Instance().ActiveDate());
            if (dictionary.ContainsKey(activeDate))
                return dictionary[activeDate].GetMultilingualName(Globals.GetCurrentUserLanguage());
            return string.Empty;
        }
    }
}
