﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {
        /// <summary>
        /// 评价按钮
        /// </summary>
        public string ShowDiggButton<T>(T digger, int itemID, string actionUrl) where T : IDiggable, new()
        {
            string wrapperID = string.Format("wrapper_{0}", itemID);
            string diggCountID = string.Format("diggCount_{0}", itemID);
            string diggLinkID = string.Format("diglink_{0}", itemID);
            StringBuilder htmlString = new StringBuilder();
            htmlString.AppendFormat("<form><div id=\"{0}\" class=\"tn-list-figure tn-widge\">", wrapperID);
            htmlString.AppendFormat("<div class=\"tn-list-figure-count tn-widget-content tn-corner-top\" ><strong property=\"review:totalVotes\" id=\"{0}\">{1}</strong></div>", diggCountID, digger.DiggerCount);
            string voteText = ResourceManager.GetString("Button_Digg", Globals.GetCurrentUserLanguage());
            if (digger.HasDigged(Globals.GetCurrentUser().UserID, itemID))
            {
                voteText = ResourceManager.GetString("Button_Dugg", Globals.GetCurrentUserLanguage());
                htmlString.AppendFormat("<a  class=\"tn-list-figure-button tn-state-default tn-corner-bottom\">{0}</a>", voteText);
            }
            else
            {
                htmlString.AppendFormat("<a  href=\"javascript:void(0)\" class=\"tn-list-figure-button tn-state-default tn-corner-bottom\"><span id=\"{0}\">{1}</span></a>", diggLinkID, voteText);
            }
            htmlString.AppendFormat("</div></form>");


            htmlString.AppendFormat(" <script type=\"text/javascript\">$(document).ready(function() {{ ");

            htmlString.AppendFormat("$(\"#diglink_{0}\").click(function() {{ ", itemID);

            htmlString.AppendFormat("$.getJSON(\"{0}\", function(data) {{ ", actionUrl);

            htmlString.AppendFormat(" if(data.isSuccess){{$(\"#diggCount_{0}\").text((eval(\"{1} +1\")).toString());  ", itemID, digger.DiggerCount);

            htmlString.AppendFormat("$(\"#diglink_{0} \").text(\"{1}\"); ", itemID, ResourceManager.GetString("Button_Dugg", Globals.GetCurrentUserLanguage()));

            htmlString.AppendFormat("$(\"#diglink_{0} \").remove(); ", itemID);

            htmlString.AppendFormat("$(\"#diggCount_{0} \").after(\"<span  class='tn-list-figure-button tn-state-default tn-corner-bottom'>已支持</span>\"); ", itemID);

            htmlString.AppendFormat("}} else alert(\"评价失败\");}}); return false;}}); ");

            htmlString.AppendFormat("}});</script>");


            return htmlString.ToString();
        }

    }
}
