﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Routing;
using SpaceBuilder.Common;
using System.Web.Mvc;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {


        /// <summary>
        /// 根据字典类型生成下拉列表
        /// </summary>
        /// <param name="controlName">下拉列表的Name</param>
        /// <param name="DicKeyValues">要填充的字典类型数据 KEY为下拉列表的value值，value为下拉列表的显示名字</param>
        /// <param name="cssClass">下拉列表的样式</param>
        /// <param name="htmlAttributes">元素属性</param>
        /// <param name="selectedValue">默认选中的值</param>
        public string ShowDropDownList<TKey, TValue>(string controlName, IDictionary<TKey, TValue> DicKeyValues, RouteValueDictionary htmlAttributes, TKey selectedKey)
        {
            return ShowDropDownList<TKey, TValue>(controlName, DicKeyValues, htmlAttributes, selectedKey, default(TKey), ResourceManager.GetString("Common_PleaseChoose", Globals.GetCurrentUserLanguage()));
        }

        /// <summary>
        /// 根据字典类型生成下拉列表
        /// </summary>
        /// <param name="controlName">下拉列表的Name</param>
        /// <param name="DicKeyValues">要填充的字典类型数据 KEY为下拉列表的value值，value为下拉列表的显示名字</param>
        /// <param name="cssClass">下拉列表的样式</param>
        /// <param name="htmlAttributes">元素属性</param>
        /// <param name="selectedValue">默认选中的Key；如果为null，则不添加“请选择”</param>
        /// <param name="defaultKey">"请选择"的Key；如果为null，则不添加“请选择”</param>
        /// <param name="defaultValue">"请选择"的Value</param>
        public string ShowDropDownList<TKey, TValue>(string controlName, IDictionary<TKey, TValue> DicKeyValues, RouteValueDictionary htmlAttributes, TKey selectedKey, TKey defaultKey, string defaultValue)
        {
            string strhtmlAttributes = string.Empty;
            TagBuilder strDropDownList = new TagBuilder("select");
            strDropDownList.MergeAttributes(htmlAttributes);
            strDropDownList.MergeAttribute("id", controlName);
            strDropDownList.MergeAttribute("name", controlName);
            TagBuilder strOption = null;
            if (!string.IsNullOrEmpty(defaultValue) && defaultKey != null)
            {
                strOption = new TagBuilder("option");
                strOption.MergeAttribute("value", defaultKey != null ? defaultKey.ToString() : string.Empty);
                strOption.InnerHtml = defaultValue;
                strDropDownList.InnerHtml += strOption.ToString();
            }
            if (DicKeyValues != null && DicKeyValues.Keys.Count > 0)
            {
                foreach (KeyValuePair<TKey, TValue> item in DicKeyValues)
                {
                    strOption = new TagBuilder("option");
                    strOption.MergeAttribute("value", item.Key.ToString(), true);
                    strOption.InnerHtml = item.Value.ToString();
                    if (item.Key.Equals(selectedKey))
                        strOption.MergeAttribute("selected", "selected");
                    strDropDownList.InnerHtml += strOption.ToString();
                }
            }
            return strDropDownList.ToString();
        }


        /// <summary>
        /// 根据字典类型生成下拉列表
        /// </summary>
        /// <param name="controlName">下拉列表的Name</param>
        /// <param name="DicKeyValues">要填充的字典类型数据 KEY为下拉列表的value值，value为下拉列表的显示名字</param>
        /// <param name="cssClass">下拉列表的样式</param>
        public string ShowDropDownList<TKey, TValue>(string controlName, IDictionary<TKey, TValue> DicKeyValues, RouteValueDictionary htmlAttributes)
        {
            return ShowDropDownList<TKey, TValue>(controlName, DicKeyValues, htmlAttributes, default(TKey));
        }
        /// <summary>
        /// 显示职位类别下拉列表
        /// </summary>
        /// <param name="controlName">下拉列表的Name</param>
        /// <param name="htmlAttributes">select的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        /// <returns></returns>
        public string ShowJobSortsDropDownList(string controlName, RouteValueDictionary htmlAttributes)
        {
            return ShowJobSortsDropDownList(controlName, htmlAttributes, string.Empty);
        }

        /// <summary>
        /// 隐私设置下拉列表
        /// </summary>
        /// <param name="controlName">控件名称</param>
        /// <param name="selectenPrivacyStatus">处于选中状态的隐私设置</param>
        /// <param name="password">设置的密码</param>
        /// <returns></returns>
        public string PrivacyStatusesDropDownList(string controlName, string cssClass, PrivacyStatuses? selectedPrivacyStatus, string password)
        {
            return PrivacyStatusesDropDownList(controlName, cssClass, selectedPrivacyStatus, password, UserTypes.PersonUser);
        }

        /// <summary>
        /// 隐私设置下拉列表
        /// </summary>
        /// <param name="controlName">控件名称</param>
        /// <param name="selectenPrivacyStatus">处于选中状态的隐私设置</param>
        /// <param name="password">设置的密码</param>
        /// <param name="password">用户类别</param>
        public string PrivacyStatusesDropDownList(string controlName, string cssClass, PrivacyStatuses? selectedPrivacyStatus, string password, UserTypes userType)
        {
            string privacyStatusesDDLString = string.Empty;
            if (selectedPrivacyStatus.HasValue)
            {
                privacyStatusesDDLString = string.Format(" <select name=\"{0}\" onchange=\"{0}_onChange(this)\" id=\"{0}\" class=\"{1}\">", controlName, cssClass);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option {1} value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_Public", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.Public, selectedPrivacyStatus.Value == PrivacyStatuses.Public ? " selected=\"selected\" " : string.Empty);
                if (userType == UserTypes.PersonUser)
                    privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option {1} value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_OnlyFriend", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.OnlyFriend, selectedPrivacyStatus.Value == PrivacyStatuses.OnlyFriend ? " selected=\"selected\" " : string.Empty);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option {1} value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_NeedPassword", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.NeedPassword, selectedPrivacyStatus.Value == PrivacyStatuses.NeedPassword ? " selected=\"selected\" " : string.Empty);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option {1} value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_Privacy", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.Privacy, selectedPrivacyStatus.Value == PrivacyStatuses.Privacy ? " selected=\"selected\" " : string.Empty);
                privacyStatusesDDLString = privacyStatusesDDLString + "</select>";

                if (selectedPrivacyStatus.Value == PrivacyStatuses.NeedPassword)
                {
                    privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<span id=\"{0}_Password_Div\" > " + ResourceManager.GetString("Common_Password", Globals.GetCurrentUserLanguage()) + ResourceManager.GetString("Common_Colon", Globals.GetCurrentUserLanguage()) + "<input type=\"password\" name=\"{0}_Password\" id=\"{0}_Password\" class=\"tn-textbox tn-input-medium tn-border-gray\" value=\"{1}\" /> </span>", controlName, password);
                }
                else
                {
                    privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<span id=\"{0}_Password_Div\" style=\"display: none;\" >" + ResourceManager.GetString("Common_Password", Globals.GetCurrentUserLanguage()) + ResourceManager.GetString("Common_Colon", Globals.GetCurrentUserLanguage()) + "<input type=\"password\" name=\"{0}_Password\" id=\"{0}_Password\" class=\"tn-textbox tn-input-medium tn-border-gray\"  disabled=\"disabled\" /> </span> ", controlName);
                }
            }
            else
            {
                privacyStatusesDDLString = string.Format(" <select name=\"{0}\" id=\"{0}\" onchange=\"{0}_onChange(this)\" class=\"{1}\">", controlName, cssClass);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option selected=\"selected\" value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_Public", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.Public);
                if (userType == UserTypes.PersonUser)
                    privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_OnlyFriend", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.OnlyFriend);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_NeedPassword", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.NeedPassword);
                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<option value=\"{0}\">" + ResourceManager.GetString("Enum_PrivacyStatuses_Privacy", Globals.GetCurrentUserLanguage()) + "</option>", (int)PrivacyStatuses.Privacy);
                privacyStatusesDDLString = privacyStatusesDDLString + "</select>";

                privacyStatusesDDLString = privacyStatusesDDLString + string.Format("<span id=\"{0}_Password_Div\" style=\"display: none;\" >  " + ResourceManager.GetString("Common_Password", Globals.GetCurrentUserLanguage()) + ResourceManager.GetString("Common_Colon", Globals.GetCurrentUserLanguage()) + "<input type=\"password\" name=\"{0}_Password\" id=\"{0}_Password\" class=\"tn-textbox tn-input-medium tn-border-gray\"  disabled=\"disabled\" /> </span> ", controlName);
            }

            privacyStatusesDDLString = privacyStatusesDDLString + " <script type=\"text/javascript\"> function " + controlName + "_onChange(currentDropDownlist) { if($(currentDropDownlist).val()=='" + ((int)PrivacyStatuses.NeedPassword).ToString() + "') { $('#" + controlName + "_Password_Div').attr('style','display: inline'); $('#" + controlName + "_Password').removeAttr('disabled');} else { $('#" + controlName + "_Password_Div').attr('style','display: none'); $('#" + controlName + "_Password').attr('disabled','disabled');} }  </script>";
            //privacyStatusesDDLString = privacyStatusesDDLString + string.Format(" <script type=\"text/javascript\"> function {1}_onChange(currentDropDownlist) { if(currentDropDownlist.vaule=='{0}') { $('#{1}_Password').attr('style','display: none');} else { $('#{1}_Password').attr('style','display: block');} }  </script>", ((int)PrivacyStatuses.NeedPassword).ToString(), controlName);
            //privacyStatusesDDLString = privacyStatusesDDLString + string.Format(" <script type=\"text/javascript\"> function {1}_onChange(currentDropDownlist) { if(currentDropDownlist.vaule=='wewe') {} }</script>", ((int)PrivacyStatuses.NeedPassword).ToString(), controlName);

            return privacyStatusesDDLString;
        }

        /// <summary>
        /// 显示职位类别下拉列表
        /// </summary>
        /// <param name="controlName">下拉列表的Name</param>
        /// <param name="htmlAttributes">select的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        /// <returns></returns>
        public string ShowJobSortsDropDownList(string controlName, RouteValueDictionary htmlAttributes, string selectValue)
        {
            SortedList<string, string> jobSorts = JobSorts.GetJobSorts();
            IEnumerable<KeyValuePair<string, string>> mainJobSorts = jobSorts.Where(n => n.Key.EndsWith("00"));
            IEnumerable<KeyValuePair<string, string>> subJobSorts = jobSorts.Where(n => !n.Key.EndsWith("00"));
            StringBuilder jsonStr = new StringBuilder();
            string currentUserLanguage = Globals.GetCurrentUserLanguage();
            jsonStr.Append("[");
            foreach (KeyValuePair<string, string> subPair in subJobSorts)
            {
                jsonStr.Append("{");
                jsonStr.Append("\"code\":");
                jsonStr.Append("\"" + subPair.Key + "\",");
                jsonStr.Append("\"name\":");
                jsonStr.Append("\"" + JobSorts.GetMultilingualJobSort(subPair.Key, currentUserLanguage) + "\"");
                jsonStr.Append("},");
            }
            if (jsonStr.Length > 1)
                jsonStr.Remove(jsonStr.Length - 1, 1);
            jsonStr.Append("]");
            StringBuilder strDropDownList = new StringBuilder();
            TagBuilder select1 = new TagBuilder("select");
            select1.MergeAttribute("id", string.Format("{0}_select1", controlName));
            select1.MergeAttribute("name", string.Format("{0}_select1", controlName));
            select1.MergeAttributes(htmlAttributes);
            TagBuilder defaultOption = new TagBuilder("option");
            defaultOption.MergeAttribute("value", "0");
            defaultOption.InnerHtml = "--" + ResourceManager.GetString("Common_PleaseChoose", Globals.GetCurrentUserLanguage()) + "--";
            select1.InnerHtml += defaultOption.ToString();
            foreach (KeyValuePair<string, string> mainPair in mainJobSorts)
            {
                TagBuilder option = new TagBuilder("option");
                option.MergeAttribute("value", mainPair.Key);
                option.InnerHtml = JobSorts.GetMultilingualJobSort(mainPair.Key, currentUserLanguage);
                select1.InnerHtml += option.ToString();
            }
            TagBuilder select2 = new TagBuilder("select");
            select2.MergeAttribute("id", string.Format("{0}_select2", controlName));
            select2.MergeAttribute("name", string.Format("{0}_select2", controlName));
            select2.MergeAttribute("style", "display:none");
            select2.MergeAttributes(htmlAttributes);
            TagBuilder hiddenInput = new TagBuilder("input");
            hiddenInput.MergeAttribute("type", "hidden");
            hiddenInput.MergeAttribute("id", controlName);
            hiddenInput.MergeAttribute("name", controlName);
            StringBuilder strScript = new StringBuilder();
            strScript.AppendLine(" <script type=\"text/javascript\">");
            strScript.AppendFormat("var jobSorts = eval('({0})');", jsonStr.ToString());
            strScript.AppendLine("$(document).ready(function(){");
            strScript.AppendFormat("$('#{0}_select1').change(function(){{ $('#{0}').val($(this).val());", controlName);
            strScript.AppendFormat("var key = $(this).val().substr(0, 2);$('#{0}'+'_select2').empty().append(\"<option value='\" + $(this).val() + \"'>--" + ResourceManager.GetString("Common_PleaseChoose", Globals.GetCurrentUserLanguage()) + "--</option>\");", controlName);
            strScript.Append("$(jobSorts).each(function(i) {if (this.code.substr(0, 2) == key)"
            + "{var option = \"<option value='\" + this.code + \"'>\" + this.name + \"</option>\";");
            strScript.AppendFormat("$('#{0}_select2').append(option);}}}});", controlName);
            strScript.AppendFormat("$('#{0}_select2').show().change(function() {{var value = $(this).val();$('#{0}').val(value);}});}});", controlName);
            strScript.AppendFormat("var selectValue=\"{1}\";if(selectValue.length==4){{", controlName, selectValue);
            strScript.AppendFormat("$(\"#{0}_select1\").val(selectValue.substr(0,2)+\"00\").change();$(\"#{0}_select2\").val(selectValue).change(); }}", controlName);
            strScript.AppendFormat(" else if(selectValue.length==0){{$('#{0}_select1').val('0');}}", controlName);
            strScript.AppendLine("});</script>");
            strDropDownList.AppendLine(select1.ToString());
            strDropDownList.AppendLine(select2.ToString());
            strDropDownList.AppendLine(hiddenInput.ToString(TagRenderMode.SelfClosing));
            strDropDownList.AppendLine(strScript.ToString());
            return strDropDownList.ToString();
        }

        /// <summary>
        /// 生成选择升序降序下拉列表
        /// </summary>
        /// <param name="selectedValue">初始选中值</param>
        /// <param name="htmlAttributes">select的html属性，例如：new{Class="dropDownList",id="SortOrderSelect"}</param>
        public string SortOrderDropdownList(SpaceBuilder.Common.SortOrder selectedValue, RouteValueDictionary htmlAttributes)
        {
            TagBuilder select = new TagBuilder("select");
            select.MergeAttributes(htmlAttributes);

            TagBuilder option1 = new TagBuilder("option");
            option1.MergeAttribute("value", "Ascending");
            option1.InnerHtml = ResourceManager.GetString("SortOrderDropDownList_Asc", Globals.GetCurrentUserLanguage());
            TagBuilder option2 = new TagBuilder("option");
            option2.MergeAttribute("value", "Descending");
            option2.InnerHtml = ResourceManager.GetString("SortOrderDropDownList_Desc", Globals.GetCurrentUserLanguage()); ;
            switch (selectedValue)
            {
                case SpaceBuilder.Common.SortOrder.Ascending:
                    option1.MergeAttribute("selected", "selected");
                    break;
                case SpaceBuilder.Common.SortOrder.Descending:
                    option2.MergeAttribute("selected", "selected");
                    break;
                default:
                    option1.MergeAttribute("selected", "selected");
                    break;
            }
            select.InnerHtml = option1.ToString() + option2.ToString();
            return select.ToString();
        }

        /// <summary>
        /// 状态下拉列表，批准未批准等状态
        /// </summary>
        /// <param name="name">下拉列表名称</param>
        /// <param name="cssClass">下拉列表样式</param>
        public string ApproveStatusDropDownList(string name, ApprovalStatuses? approvalStatus, string cssClass, string onChange)
        {
            StringBuilder approveStatusDropDownList = new StringBuilder();
            string allStatus = ResourceManager.GetString("Enum_ApprovalStatuses_All", Globals.GetCurrentUserLanguage());
            string notApprove = ResourceManager.GetString("Enum_ApprovalStatuses_NotApprove", Globals.GetCurrentUserLanguage());
            string isApprove = ResourceManager.GetString("Enum_ApprovalStatuses_IsApproved", Globals.GetCurrentUserLanguage());

            if (string.IsNullOrEmpty(name))
                return string.Empty;
            if (string.IsNullOrEmpty(cssClass))
                approveStatusDropDownList.AppendFormat("<select name=\"{0}\" id=\"{0}\" onchange=\"{1}\"> ", name, onChange);
            else
                approveStatusDropDownList.AppendFormat("<select name=\"{0}\" id=\"{0}\" class=\"{1}\" onchange=\"{2}\">", name, cssClass, onChange);
            if (approvalStatus == null)
            {
                approveStatusDropDownList.AppendFormat("<option selected=\"selected\" value=\"{0}\">{1}</option> ", "-1", allStatus);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.NotApprove).ToString(), notApprove);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.IsApproved).ToString(), isApprove);
            }
            else if (approvalStatus == ApprovalStatuses.IsApproved)
            {
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", "-1", allStatus);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.NotApprove).ToString(), notApprove);
                approveStatusDropDownList.AppendFormat("<option selected=\"selected\" value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.IsApproved).ToString(), isApprove);
            }
            else if (approvalStatus == ApprovalStatuses.NotApprove)
            {
                approveStatusDropDownList.AppendFormat("<option selected=\"selected\" value=\"{0}\">{1}</option> ", "-1", allStatus);
                approveStatusDropDownList.AppendFormat("<option selected=\"selected\" value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.NotApprove).ToString(), notApprove);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.IsApproved).ToString(), isApprove);
            }
            else
            {
                approveStatusDropDownList.AppendFormat("<option selected=\"selected\" value=\"{0}\">{1}</option> ", "-1", allStatus);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.NotApprove).ToString(), notApprove);
                approveStatusDropDownList.AppendFormat("<option value=\"{0}\">{1}</option> ", ((int)ApprovalStatuses.IsApproved).ToString(), isApprove);
            }
            approveStatusDropDownList.Append("</select>");
            return approveStatusDropDownList.ToString();
        }

    }
}
