﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;

using System.Web.Mvc;
using System.IO;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {

        /// <summary>
        /// 根据文件类型显示缩略图
        /// </summary>
        public string ContentTypeThumbnail(string fileName, ContentTypeThumbnailSize thumbnailSize)
        {
            return ContentTypeThumbnail(fileName, thumbnailSize, string.Empty, HyperLinkTarget._self);
        }

        /// <summary>
        /// 根据文件类型显示缩略图
        /// </summary>
        public string ContentTypeThumbnail(string fileName, ContentTypeThumbnailSize thumbnailSize, string navigateUrl, HyperLinkTarget navigateTarget)
        {
            string fileExtension = Path.GetExtension(fileName);
            string thumbnail = GetContentTypeThumbnail(fileExtension, thumbnailSize);
            if (!string.IsNullOrEmpty(navigateUrl))
            {
                TagBuilder a = new TagBuilder("a");
                a.MergeAttribute("href", navigateUrl);

                if (navigateTarget != HyperLinkTarget._self)
                    a.MergeAttribute("target", navigateTarget.ToString());

                a.InnerHtml = thumbnail;
                return a.ToString();
            }
            else
                return thumbnail;
        }

        /// <summary>
        /// 根据文件类型显示缩略图
        /// </summary>
        public string ContentTypeThumbnail(string fileExtension)
        {
            return GetContentTypeThumbnail(fileExtension, ContentTypeThumbnailSize.Small);
        }

        /// <summary>
        /// 获取博客附件的缩略图
        /// </summary>
        public string ShowAttachmentThumbnail(Attachment attachment, ContentTypeThumbnailSize thumbnailSize, Func<int, string> getAttachmentUrl)
        {
            if (attachment == null)
                return string.Empty;

            string filename = attachment.FileName;
            if ((thumbnailSize == ContentTypeThumbnailSize.Small) || (!MimeTypeConfiguration.GetMimeType(attachment.FileName).StartsWith("image")))
                return ContentTypeThumbnail(attachment.FileName, thumbnailSize);

            int maxThumbnailSize = 48;
            if (thumbnailSize == ContentTypeThumbnailSize.Large)
                maxThumbnailSize = 75;

            double width = 0.0;
            double height = 0.0;
            int tnWidth = 0;
            int tnHeight = 0;

            width = Convert.ToDouble(attachment.Width);
            height = Convert.ToDouble(attachment.Height);

            if (height > 0d && width > 0d)
            {
                if (width >= height)
                {
                    tnWidth = maxThumbnailSize;
                    tnHeight = Convert.ToInt32(Math.Round(height / width * Convert.ToDouble(maxThumbnailSize), MidpointRounding.AwayFromZero));
                }
                else
                {
                    tnHeight = maxThumbnailSize;
                    tnWidth = Convert.ToInt32(Math.Round(width / height * Convert.ToDouble(maxThumbnailSize), MidpointRounding.AwayFromZero));
                }
            }

            return string.Format("<img src=\"{0}\" width=\"{1}\" height=\"{2}\" alt=\"{3}\" border=\"0\" align=\"absmiddle\" />", getAttachmentUrl(attachment.AttachmentID), tnWidth, tnHeight, attachment.FriendlyFileName);
        }

        /// <summary>
        /// 根据文件扩展名获得预览图片路径
        /// </summary>
        private string GetContentTypeThumbnail(string fileExtension, ContentTypeThumbnailSize size)
        {
            if (string.IsNullOrEmpty(fileExtension))
                return string.Empty;
            if (fileExtension.Length > 1 && fileExtension.StartsWith("."))
                fileExtension = fileExtension.Substring(1);
            TagBuilder span = new TagBuilder("span");
            if (!MimeTypeConfiguration.Extensions.Contains(fileExtension))
            {
                fileExtension = "unknown";
            }

            switch (size)
            {
                case ContentTypeThumbnailSize.Large:
                    span.AddCssClass(string.Format("tn-mime-big tn-mime-{0}-big  tn-icon-inline", fileExtension));
                    break;
                case ContentTypeThumbnailSize.Normal:
                case ContentTypeThumbnailSize.Small:
                default:
                    span.AddCssClass(string.Format("tn-mime tn-mime-{0}  tn-icon-inline", fileExtension));
                    break;
            }
                        
            return span.ToString();
        }
    }
}
