﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Utils;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Common;
using System.Configuration;


namespace SpaceBuilder.Web
{
    /// <summary>
    /// HtmlEditor辅助生成控件
    /// </summary>
    /// <remarks>
    /// user TinyMCE editor
    /// </remarks>
    public partial class SPBHtmlHelper
    {
        ///<overloads>生成HtmlEditor</overloads>
        /// <summary>
        /// 生成HtmlEditor
        /// </summary>
        /// <param name="editorMode">HtmlEditor显示方式</param>
        /// <param name="name">生成的textarea的name及id</param>
        /// <param name="htmlAttributes">textarea的其他html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        /// <returns></returns>
        public string HtmlEditor(HtmlEditorMode editorMode, string name, RouteValueDictionary htmlAttributes)
        {
            return HtmlEditor(editorMode, name, string.Empty, htmlAttributes, string.Empty, string.Empty, false);
        }

        ///<overloads>生成HtmlEditor</overloads>
        /// <summary>
        /// 生成HtmlEditor
        /// </summary>
        /// <param name="editorMode">HtmlEditor显示方式</param>
        /// <param name="name">生成的textarea的name及id</param>
        /// <param name="htmlAttributes">textarea的其他html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        /// <returns></returns>
        public string HtmlEditor(HtmlEditorMode editorMode, string name, RouteValueDictionary htmlAttributes, string uploadAttachmentUrl)
        {
            return HtmlEditor(editorMode, name, string.Empty, htmlAttributes, uploadAttachmentUrl, string.Empty, false);
        }
        /// <summary>
        /// 生成HtmlEditor
        /// </summary>
        /// <param name="editorMode">HtmlEditor显示方式</param>
        /// <param name="name">生成的textarea的name及id</param>
        /// <param name="value">显示内容</param>
        /// <param name="htmlAttributes">textarea的其他html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string HtmlEditor(HtmlEditorMode editorMode, string name, string value, RouteValueDictionary htmlAttributes)
        {
            return HtmlEditor(editorMode, name, value, htmlAttributes, string.Empty, string.Empty, false);
        }
        /// <summary>
        /// 生成HtmlEditor
        /// </summary>
        /// <param name="editorMode">HtmlEditor显示方式</param>
        /// <param name="name">生成的textarea的name及id</param>
        /// <param name="value">显示内容</param>
        /// <param name="htmlAttributes">textarea的其他html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string HtmlEditor(HtmlEditorMode editorMode, string name, string value, RouteValueDictionary htmlAttributes, string uploadAttachmentUrl)
        {
            return HtmlEditor(editorMode, name, value, htmlAttributes, string.Empty, uploadAttachmentUrl, false);
        }

        public string HtmlEditor(HtmlEditorMode editorMode, string name, string value, RouteValueDictionary htmlAttributes, string uploadPhotoUrl, string uploadAttachmentUrl)
        {
            return HtmlEditor(editorMode, name, value, htmlAttributes, uploadPhotoUrl, uploadAttachmentUrl, false);
        }
        /// <summary>
        /// 生成HtmlEditor
        /// </summary>
        /// <param name="editorMode">HtmlEditor显示方式</param>
        /// <param name="name">生成的textarea的name及id</param>
        /// <param name="value">显示内容</param>
        /// <param name="htmlAttributes">textarea的其他html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string HtmlEditor(HtmlEditorMode editorMode, string name, string value, RouteValueDictionary htmlAttributes, string uploadPhotoUrl, string uploadAttachmentUrl, bool includePagebreak)
        {
            if (string.IsNullOrEmpty(name))
            {
                throw new ArgumentException("参数名称name不能为空", "name");
            }

            StringBuilder htmlString = new StringBuilder();
            htmlString.Append("<ul class=\"tn-editor-tools tn-helper-clearfix\">");
            if (!string.IsNullOrEmpty(uploadPhotoUrl))
                htmlString.AppendFormat("<li>{0}</li>", SPBHtmlHelper.Instance().Button("insertPhoto", "插入图片", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Picture, TextIconLayout.IconText, null, null));
            if (!string.IsNullOrEmpty(uploadAttachmentUrl))
                htmlString.AppendFormat("<li>{0}</li>", SPBHtmlHelper.Instance().Button("insertAttachment", "插入附件", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.PaperClip, TextIconLayout.IconText, null, null));
            htmlString.AppendFormat("<li>{0}</li>", SPBHtmlHelper.Instance().Button("insertEmotion", "插入表情", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Emotion, TextIconLayout.IconText, null, null));
            htmlString.Append("</ul>\n");
            htmlString.Append("<span class=\"mceEditor defaultSkin\">\n");

            if (editorMode != HtmlEditorMode.PlainText)
            {
                //TinyMCE安装路径
                string tinyMCEInstallPath = "~/tiny_mce";


                //TinyMCE的JavaScript是否允许gzip压缩
                bool tinyMCEJavaScriptGzipEnabled = Convert.ToBoolean(ConfigurationManager.AppSettings["EnableHttpCompress"]);

                string scriptURI;
                string language = "zh";
                if (Globals.GetCurrentUserLanguage().Length > 2)
                    language = Globals.GetCurrentUserLanguage().Substring(0, 2);
                string plugins = string.Empty;
                string theme;
                switch (editorMode)
                {
                    case HtmlEditorMode.Simple:
                        plugins = "style";
                        theme = "advanced";
                        break;
                    case HtmlEditorMode.Enhanced:
                        plugins = "paste,fullscreen,style,media,contextmenu,inlinepopups,changemode,syntaxhl,table";
                        if (includePagebreak)
                            plugins += ",pagebreak";
                        theme = "advanced";
                        break;
                    case HtmlEditorMode.Standard:
                    default:
                        plugins = "paste,fullscreen,style,media,contextmenu,inlinepopups,table";
                        theme = "advanced";
                        break;
                }
                scriptURI = tinyMCEInstallPath + string.Format("/tiny_mce{0}.js", tinyMCEJavaScriptGzipEnabled ? "_gzip" : string.Empty);
                htmlString.AppendFormat("<script type=\"text/javascript\" src=\"{0}\"></script>", Globals.GetFullUrlInResourceSite(scriptURI));

                StringBuilder tinyMCE_init = new StringBuilder();

                //高级模式的简单模式
                StringBuilder tinyMCE_init_Enhanced_Simple = new StringBuilder();

                tinyMCE_init.Append("tinyMCE.init({");
                tinyMCE_init.Append("relative_urls:false");
                tinyMCE_init.Append(",remove_linebreaks:false");
                tinyMCE_init.AppendFormat(",language:'{0}'", language);
                tinyMCE_init.Append(",mode:'exact'");
                tinyMCE_init.AppendFormat(",elements:'{0}'", name);

                if (editorMode == HtmlEditorMode.Enhanced)
                {
                    tinyMCE_init_Enhanced_Simple.Append("tinyMCE.init({");
                    tinyMCE_init_Enhanced_Simple.Append("relative_urls:false");
                    tinyMCE_init_Enhanced_Simple.Append(",remove_linebreaks:false");
                    tinyMCE_init_Enhanced_Simple.AppendFormat(",language:'{0}'", language);
                    tinyMCE_init_Enhanced_Simple.Append(",mode:'exact'");
                    tinyMCE_init_Enhanced_Simple.AppendFormat(",elements:'{0}'", name);
                }

                if (!string.IsNullOrEmpty(plugins))
                {
                    tinyMCE_init.AppendFormat(",plugins:'{0}'", plugins);

                    if (editorMode == HtmlEditorMode.Enhanced)
                        tinyMCE_init_Enhanced_Simple.AppendFormat(",plugins:'{0}'", plugins);
                }

                tinyMCE_init.AppendFormat(",theme:'{0}'", theme);
                tinyMCE_init_Enhanced_Simple.AppendFormat(",theme:'{0}'", theme);

                tinyMCE_init.Append(",theme_advanced_toolbar_location:'top'");
                tinyMCE_init.Append(",theme_advanced_toolbar_align:'left'");
                tinyMCE_init.Append(",theme_advanced_statusbar_location:'bottom'");
                tinyMCE_init.Append(",theme_advanced_resizing:'true'");
                tinyMCE_init.Append(",theme_advanced_resize_horizontal:'false'");
                tinyMCE_init.Append(",theme_advanced_statusbar_location:'bottom'");
                tinyMCE_init.Append(",theme_advanced_resizing:'true'");

                if (editorMode == HtmlEditorMode.Enhanced)
                {
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_toolbar_location:'top'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_toolbar_align:'left'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_statusbar_location:'bottom'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_resizing:'true'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_resize_horizontal:'false'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_statusbar_location:'bottom'");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_resizing:'true'");
                }

                if (editorMode == HtmlEditorMode.Simple)
                {
                    tinyMCE_init.AppendFormat(",theme_advanced_buttons1:'{0}'", "fontselect,fontsizeselect,|,forecolor,backcolor,|,bold,italic,underline,strikethrough,|,bullist,numlist|,table,|,link,unlink");
                    tinyMCE_init.Append(",theme_advanced_buttons2:''");
                }
                else if (editorMode == HtmlEditorMode.Standard)
                {
                    tinyMCE_init.AppendFormat(",theme_advanced_buttons1:'{0}'", "fontselect,fontsizeselect,|,forecolor,backcolor,|,bold,italic,underline,strikethrough,|,bullist,numlist|,table,|,link,unlink,anchor,|,image,media");
                    tinyMCE_init.Append(",theme_advanced_buttons2:''");
                }
                else if (editorMode == HtmlEditorMode.Enhanced)
                {
                    if (includePagebreak)
                        tinyMCE_init.AppendFormat(",theme_advanced_buttons1:'{0}'", "fontselect,fontsizeselect,|,forecolor,backcolor,|,styleprops,removeformat,cleanup,|,bullist,numlist|,table,|,undo,redo,|,pagebreak,cut,copy,pastetext,pasteword,|,code,|,changemode");
                    else
                        tinyMCE_init.AppendFormat(",theme_advanced_buttons1:'{0}'", "fontselect,fontsizeselect,|,forecolor,backcolor,|,styleprops,removeformat,cleanup,|,table,|,undo,redo,|,cut,copy,pastetext,pasteword,|,code,|,fullscreen,changemode");
                    tinyMCE_init.AppendFormat(",theme_advanced_buttons2:'{0}'", "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,indent,outdent,|,link,unlink,anchor,|,bullist,numlist,|,sub,sup,|,hr,charmap,image,media,|,syntaxhl");
                }
                tinyMCE_init.Append(",theme_advanced_buttons3:''");

                if (editorMode == HtmlEditorMode.Enhanced)
                {
                    if (includePagebreak)
                        tinyMCE_init_Enhanced_Simple.AppendFormat(",theme_advanced_buttons1:'{0}'", "bold,italic,underline,strikethrough,|,fontsizeselect,|,forecolor,backcolor,|,bullist,numlist,|,table,|,link,unlink,|,image,media,|,pagebreak,smilies,contentselector,changemode");
                    else
                        tinyMCE_init_Enhanced_Simple.AppendFormat(",theme_advanced_buttons1:'{0}'", "bold,italic,underline,strikethrough,|,fontsizeselect,|,forecolor,backcolor,|,bullist,numlist,|,table,|,link,unlink,|,image,media,|,changemode");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_buttons2:''");
                    tinyMCE_init_Enhanced_Simple.Append(",theme_advanced_buttons3:''");
                    tinyMCE_init_Enhanced_Simple.Append("});");
                }
                tinyMCE_init.Append("});");

                StringBuilder changeModeFunctionScript = null;
                if (editorMode == HtmlEditorMode.Enhanced)
                {
                    changeModeFunctionScript = new StringBuilder("function tinymceChangeMode(){ \n ");
                    changeModeFunctionScript.AppendFormat("tinyMCE.execCommand('mceRemoveControl', false, '{0}'); \n", name);
                    changeModeFunctionScript.Append("if (tinyMCE_TunyNetOptions.ChangeMode_IsFull){ \n");
                    changeModeFunctionScript.Append("tinyMCE_TunyNetOptions.ChangeMode_IsFull = false; \n");
                    changeModeFunctionScript.Append(tinyMCE_init_Enhanced_Simple.ToString());
                    changeModeFunctionScript.Append(" \n}else{ \n");
                    changeModeFunctionScript.Append("tinyMCE_TunyNetOptions.ChangeMode_IsFull = true; \n");
                    changeModeFunctionScript.Append(tinyMCE_init.ToString());
                    changeModeFunctionScript.Append(" \n} \n");
                    changeModeFunctionScript.AppendFormat("tinyMCE.execCommand('mceAddControl', false, '{0}'); \n", name);
                    changeModeFunctionScript.Append("}; \n");
                }

                htmlString.Append("<script type=\"text/javascript\">");
                htmlString.Append("$(document).ready(function() {");
                if (!string.IsNullOrEmpty(uploadPhotoUrl))
                {
                    htmlString.Append("$(\"#insertPhoto\").click(function(){");
                    htmlString.Append("tinyMCE.activeEditor.focus();tinyMCE.activeEditor.windowManager.bookmark = tinyMCE.activeEditor.selection.getBookmark(1);");
                    htmlString.AppendFormat("$.dialog.load('{0}',{{ id:'insertPhotoDialog',title:\"{1}\",width:580,height:530 }});\n", SiteUrls.Instance().UserContentSelector(uploadPhotoUrl, true), "上传图片");
                    htmlString.Append("});\n");
                }
                if (!string.IsNullOrEmpty(uploadAttachmentUrl))
                {
                    htmlString.Append("$(\"#insertAttachment\").click(function(){");
                    htmlString.Append("tinyMCE.activeEditor.focus();tinyMCE.activeEditor.windowManager.bookmark = tinyMCE.activeEditor.selection.getBookmark(1);");
                    htmlString.AppendFormat("$.dialog.load('{0}',{{id:'insertAttachmentDialog', title:\"{1}\",width:580,height:530}});", SiteUrls.Instance().UserContentSelector(uploadAttachmentUrl, false), "上传附件");
                    htmlString.Append("});\n");
                }
                htmlString.Append("$(\"#insertEmotion\").click(function(){");
                htmlString.Append("tinyMCE.activeEditor.focus();tinyMCE.activeEditor.windowManager.bookmark = tinyMCE.activeEditor.selection.getBookmark(1);");
                htmlString.Append("var iof = $(this).offset();");
                htmlString.AppendFormat("$.dialog.load('{0}',{{id:'insertEmotionDialog', title:\"{1}\", left:iof.left,top:iof.top + 23, width:370,height:230}});", SiteUrls.Instance().SmileySelector(), "插入表情");
                htmlString.Append("});\n");
                htmlString.Append("});\n");

                if (editorMode == HtmlEditorMode.Enhanced)
                    htmlString.AppendFormat("tinyMCE_TunyNetOptions = {{ ChangeMode_IsFull:false,ChangeModeFunctionScript:tinymceChangeMode}};");
                else
                    htmlString.AppendFormat("tinyMCE_TunyNetOptions = {{ }};");

                htmlString.AppendFormat("\n function InsertContentToHtmlEditor(content){{tinyMCE.activeEditor.selection.moveToBookmark(tinyMCE.activeEditor.windowManager.bookmark);tinyMCE.activeEditor.windowManager.bookmark=0;"
                                        + "tinyMCE.get('{0}').execCommand('mceInsertContent',false,content);}};", name);

                if (tinyMCEJavaScriptGzipEnabled)
                {
                    htmlString.AppendLine("tinyMCE_GZ.init({");
                    htmlString.AppendFormat("plugins:'{0}',\n", plugins);
                    htmlString.AppendFormat("themes : '{0}',", theme);
                    htmlString.AppendFormat("languages : '{0}',", language);
                    htmlString.AppendLine("disk_cache : true,");
                    htmlString.AppendLine("debug : false});");
                }

                if (editorMode == HtmlEditorMode.Enhanced)
                {
                    htmlString.Append("\n " + changeModeFunctionScript.ToString() + "\n");
                    htmlString.Append("\n " + tinyMCE_init_Enhanced_Simple.ToString() + "\n");
                }
                else
                    htmlString.Append("\n " + tinyMCE_init.ToString() + "\n");

                htmlString.Append("</script>");
            }
            TagBuilder tabBuilder = new TagBuilder("textarea");
            if (htmlAttributes != null)
                tabBuilder.MergeAttributes(htmlAttributes);

            tabBuilder.MergeAttribute("name", name);
            tabBuilder.MergeAttribute("id", name);

            if (value == null)
                value = string.Empty;

            if (editorMode == HtmlEditorMode.PlainText)
                tabBuilder.InnerHtml = value;
            else
                tabBuilder.InnerHtml = WebUtils.HtmlEncode(value);

            htmlString.Append(tabBuilder.ToString());

            return htmlString.ToString() + "</span>";
        }
    }


    /// <summary>
    /// HtmlEditor显示方式
    /// </summary>
    public enum HtmlEditorMode
    {
        /// <summary>
        /// 简单文本
        /// </summary>
        PlainText,

        /// <summary>
        /// 简单模式
        /// </summary>
        Simple,

        /// <summary>
        /// 标准模式
        /// </summary>
        Standard,

        /// <summary>
        /// 高级模式（可以进行切换）
        /// </summary>
        Enhanced
    }






}
