﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Text.RegularExpressions;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    /// <summary>
    /// 分页按钮控件
    /// </summary>
    public partial class SPBHtmlHelper
    {
        public string MobilePagingButton(PaginationMode paginationMode, int totalRecords, int pageSize, int pageIndex)
        {
            return MobilePagingButton(paginationMode, totalRecords, pageSize, pageIndex, 7, null, false, null);
        }

        /// <summary>
        /// 呈现分页按钮
        /// </summary>
        /// <param name="paginationMode">分页按钮显示模式</param>
        /// <param name="totalRecords">总记录数</param>
        /// <param name="pageSize">每页显示记录数</param>
        /// <param name="pageIndex">当前页码（从1开始）</param>
        /// <param name="numericPagingButtonCount">数字分页按钮显示个数</param>
        /// <param name="pagingButtonUrlPattern">链接格式（例如：http://www.spacebuilder.cn/blog/list?pageIndex={0}）</param>
        /// <param name="enableAjax">是否使用ajax分页</param>
        /// <param name="pageIndexChangeCallback">点击分页按钮时客户端回调的JavaScript函数</param>
        /// <returns>分页按钮html代码</returns>
        private string MobilePagingButton(PaginationMode paginationMode, int totalRecords, int pageSize, int pageIndex, int numericPagingButtonCount, string pagingButtonUrlPattern, bool enableAjax, string pageIndexChangeCallback)
        {
            if (totalRecords == 0 || pageSize == 0)
                return string.Empty;

            //计算总页数
            int totalPages = totalRecords / pageSize;
            if ((totalRecords % pageSize) > 0)
                totalPages++;

            //未超过一页时不显示分页按钮
            if (totalPages <= 1)
                return string.Empty;

            bool showFirst = false;
            if (paginationMode == PaginationMode.NextPreviousFirstLast)
                showFirst = true;

            bool showLast = false;
            if (paginationMode == PaginationMode.NextPreviousFirstLast)
                showLast = true;

            bool showPrevious = true;
            //if (paginationMode == PaginationMode.NextPrevious || paginationMode == PaginationMode.NextPreviousFirstLast || paginationMode == PaginationMode.NumericNextPrevious)
            //    showPrevious = true;

            bool showNext = true;
            //if (paginationMode == PaginationMode.NextPrevious || paginationMode == PaginationMode.NextPreviousFirstLast || paginationMode == PaginationMode.NumericNextPrevious)
            //    showNext = true;

            bool showNumeric = false;
            if (paginationMode == PaginationMode.NumericNextPrevious)
                showNumeric = true;

            //显示多少个数字分页按钮
            //int numericPageButtonCount = 10;

            //对pageIndex进行修正
            if ((pageIndex < 1) || (pageIndex > totalPages))
                pageIndex = 1;

            StringBuilder pagingButtonsHtml = new StringBuilder("<div>");

            //构建 "首页"
            if (showFirst)
            {
                if ((pageIndex > 1) && (totalPages > numericPagingButtonCount))
                {
                    pagingButtonsHtml.AppendLine();
                    if (enableAjax)
                        pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(ResourceManager.GetString("Common_PagerFirstButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(1, pagingButtonUrlPattern), pageIndexChangeCallback, "pre", GetPagingNavigateUrl(1, null)));
                    else
                        pagingButtonsHtml.AppendFormat(BuildLinkWithHref(ResourceManager.GetString("Common_PagerFirstButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(1, pagingButtonUrlPattern), "pre"));
                }
                else if (paginationMode == PaginationMode.NextPreviousFirstLast)
                {
                    pagingButtonsHtml.AppendLine();
                    pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", ResourceManager.GetString("Common_PagerFirstButton", Globals.GetCurrentUserLanguage()));
                }
            }

            //构建 "上一页"
            if (showPrevious)
            {
                pagingButtonsHtml.AppendLine();
                if (pageIndex == 1)
                    pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", ResourceManager.GetString("Common_PagerPreviousButton", Globals.GetCurrentUserLanguage()));
                else
                {
                    if (enableAjax)
                        pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(ResourceManager.GetString("Common_PagerPreviousButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(pageIndex - 1, pagingButtonUrlPattern), pageIndexChangeCallback, "pre", GetPagingNavigateUrl(pageIndex - 1, null)));
                    else
                        pagingButtonsHtml.AppendFormat(BuildLinkWithHref(ResourceManager.GetString("Common_PagerPreviousButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(pageIndex - 1, pagingButtonUrlPattern), "pre"));
                }
            }

            //构建 数字分页部分
            if (showNumeric)
            {
                int startNumericPageIndex;
                if (numericPagingButtonCount > totalPages || pageIndex - (numericPagingButtonCount / 2) <= 0)
                    startNumericPageIndex = 1;
                else if (pageIndex + (numericPagingButtonCount / 2) > totalPages)
                    startNumericPageIndex = totalPages - numericPagingButtonCount + 1;
                else
                    startNumericPageIndex = pageIndex - (numericPagingButtonCount / 2);

                if (startNumericPageIndex < 1)
                    startNumericPageIndex = 1;

                int lastNumericPageIndex = startNumericPageIndex + numericPagingButtonCount - 1;
                if (lastNumericPageIndex > totalPages)
                    lastNumericPageIndex = totalPages;

                if (startNumericPageIndex > 1)
                {
                    for (int i = 1; i < startNumericPageIndex; i++)
                    {
                        pagingButtonsHtml.AppendLine();

                        if (i > 3)
                            break;
                        if (i == 3)
                            pagingButtonsHtml.Append("<span>...</span>");
                        else
                        {
                            if (pageIndex == i)
                            {
                                pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", i);
                            }
                            else
                            {
                                if (enableAjax)
                                    pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), pageIndexChangeCallback, string.Empty, GetPagingNavigateUrl(i, null)));
                                else
                                    pagingButtonsHtml.AppendFormat(BuildLinkWithHref(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), string.Empty));
                            }
                        }
                    }
                }

                for (int i = startNumericPageIndex; i <= lastNumericPageIndex; i++)
                {
                    pagingButtonsHtml.AppendLine();
                    if (pageIndex == i)
                    {
                        pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", i);
                    }
                    else
                    {
                        if (enableAjax)
                            pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), pageIndexChangeCallback, string.Empty, GetPagingNavigateUrl(i, null)));
                        else
                            pagingButtonsHtml.AppendFormat(BuildLinkWithHref(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), string.Empty));
                    }
                }

                if (lastNumericPageIndex < totalPages)
                {
                    int lastStart = lastNumericPageIndex + 1;
                    if (totalPages - lastStart > 2)
                        lastStart = totalPages - 2;

                    for (int i = lastStart; i <= totalPages; i++)
                    {
                        pagingButtonsHtml.AppendLine();
                        if ((i == lastStart) && (totalPages - lastNumericPageIndex > 3))
                        {
                            pagingButtonsHtml.AppendLine();
                            pagingButtonsHtml.Append("<span>...</span>");
                            continue;
                        }

                        if (pageIndex == i)
                        {
                            pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", i);
                        }
                        else
                        {
                            if (enableAjax)
                                pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), pageIndexChangeCallback, string.Empty, GetPagingNavigateUrl(i, null)));
                            else
                                pagingButtonsHtml.AppendFormat(BuildLinkWithHref(i.ToString(), GetPagingNavigateUrl(i, pagingButtonUrlPattern), string.Empty));
                        }
                    }
                }

            }

            if (showNext)
            {
                pagingButtonsHtml.AppendLine();
                if (pageIndex == totalPages)
                    pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", ResourceManager.GetString("Common_PagerNextButton", Globals.GetCurrentUserLanguage()));
                else
                {
                    if (enableAjax)
                        pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(ResourceManager.GetString("Common_PagerNextButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(pageIndex + 1, pagingButtonUrlPattern), pageIndexChangeCallback, string.Empty, GetPagingNavigateUrl(pageIndex + 1, null)));
                    else
                        pagingButtonsHtml.AppendFormat(BuildLinkWithHref(ResourceManager.GetString("Common_PagerNextButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(pageIndex + 1, pagingButtonUrlPattern), string.Empty));
                }
            }

            if (showLast)
            {
                if ((pageIndex < totalPages) && (totalPages > numericPagingButtonCount))
                {
                    pagingButtonsHtml.AppendLine();

                    if (enableAjax)
                        pagingButtonsHtml.AppendFormat(BuildLinkWithOnClick(ResourceManager.GetString("Common_PagerLastButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(totalPages, pagingButtonUrlPattern), pageIndexChangeCallback, string.Empty, GetPagingNavigateUrl(totalPages, null)));
                    else
                        pagingButtonsHtml.AppendFormat(BuildLinkWithHref(ResourceManager.GetString("Common_PagerLastButton", Globals.GetCurrentUserLanguage()), GetPagingNavigateUrl(totalPages, pagingButtonUrlPattern), string.Empty));
                }
                else if (paginationMode == PaginationMode.NextPreviousFirstLast)
                {
                    pagingButtonsHtml.AppendLine();
                    pagingButtonsHtml.AppendFormat("<strong>{0}</strong>", ResourceManager.GetString("Common_PagerLastButton", Globals.GetCurrentUserLanguage()));
                }
            }
            pagingButtonsHtml.Append("</div>");
            return pagingButtonsHtml.ToString();
        }
    }
}