﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Routing;
using System.Web.Mvc;
using SpaceBuilder.Common;

namespace SpaceBuilder.Web
{
    public partial class SPBHtmlHelper
    {
        /// <summary>
        /// 根据字典类型生成RadioButtonList
        /// </summary>
        /// <param name="controlName">RadioButtonList的Name</param>
        /// <param name="DicKeyValues">要填充的字典类型数据 KEY为RadioButtonList的value值，value为RadioButtonList的显示名字</param>
        /// <param name="htmlAttributes">元素属性</param>
        /// <param name="selectedValue">默认选中的值</param>
        public string ShowRadioButtonList<TKey, TValue>(string controlName, IDictionary<TKey, TValue> DicKeyValues, RouteValueDictionary htmlAttributes, TKey selectedValue)
        {
            StringBuilder strRadioButtonList = new StringBuilder();
            foreach (KeyValuePair<TKey, TValue> pair in DicKeyValues)
            {
                TagBuilder input = new TagBuilder("input");
                input.MergeAttribute("type", "radio");
                input.MergeAttribute("name", controlName);
                input.MergeAttribute("id", string.Format("{0}_{1}", controlName, pair.Key.ToString()));
                input.MergeAttribute("value", pair.Key.ToString());
                input.MergeAttributes(htmlAttributes);
                if (selectedValue.Equals(pair.Key))
                    input.MergeAttribute("checked", "checked");
                TagBuilder label = new TagBuilder("label");
                label.MergeAttribute("for", input.Attributes["id"]);
                label.InnerHtml = pair.Value.ToString();
                strRadioButtonList.AppendLine(input.ToString());
                strRadioButtonList.AppendLine(label.ToString());
            }
            return strRadioButtonList.ToString();
        }
        /// <summary>
        /// 根据字典类型生成RadioButtonList
        /// </summary>
        /// <param name="controlName">RadioButtonList的Name</param>
        /// <param name="DicKeyValues">要填充的字典类型数据 KEY为RadioButtonList的value值，value为RadioButtonList的显示名字</param>
        /// <param name="htmlAttributes">元素属性</param>
        /// <param name="selectedValue">默认选中的值</param>
        public string ShowRadioButtonList<TKey, TValue>(string controlName, IDictionary<TKey, TValue> DicKeyValues, RouteValueDictionary htmlAttributes)
        {
            return ShowRadioButtonList<TKey, TValue>(controlName, DicKeyValues, htmlAttributes, default(TKey));
        }

        /// <summary>
        /// 生成YesNoRadioButtonList
        /// </summary>
        /// <param name="name">生成的radiobutton的name</param>
        /// <param name="selectedValue">初始选中值</param>
        /// <param name="htmlAttributes">RadioButton的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string YesNoRadioButtonList(string name, bool selectedValue, RouteValueDictionary htmlAttributes)
        {
            StringBuilder radioButtonList = new StringBuilder();
            TagBuilder input_true = new TagBuilder("input");
            input_true.MergeAttributes(new RouteValueDictionary(new { id = name + "-true", type = "radio", name = name, value = "true" }));
            input_true.MergeAttributes(htmlAttributes);
            TagBuilder input_false = new TagBuilder("input");
            input_false.MergeAttributes(new RouteValueDictionary(new { id = name + "-false", type = "radio", name = name, value = "false" }));
            input_false.MergeAttributes(htmlAttributes);
            if (selectedValue)
                input_true.MergeAttribute("checked", "checked");
            else
                input_false.MergeAttribute("checked", "checked");
            radioButtonList.Append(input_true.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">" + ResourceManager.GetString("Common_Yes", Globals.GetCurrentUserLanguage()) + "</label>", name + "-true");
            radioButtonList.Append(input_false.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">" + ResourceManager.GetString("Common_No", Globals.GetCurrentUserLanguage()) + "</label>", name + "-false");

            return radioButtonList.ToString();
        }

        /// <summary>
        /// 生成PrivacyTypeRadioButtonList
        /// </summary>
        /// <param name="name">生成的radiobutton的name</param>
        /// <param name="selectedValue">初始选中值</param>
        /// <param name="htmlAttributes">RadioButton的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string PrivacyTypeRadioButtonList(string name, PrivacyDegree selectedValue, RouteValueDictionary htmlAttributes)
        {
            StringBuilder radioButtonList = new StringBuilder();
            TagBuilder input_public = new TagBuilder("input");
            input_public.MergeAttributes(new RouteValueDictionary(new { id = name + "-public", type = "radio", name = name, value = "1" }));
            input_public.MergeAttributes(htmlAttributes);
            TagBuilder input_friend = new TagBuilder("input");
            input_friend.MergeAttributes(new RouteValueDictionary(new { id = name + "-friend", type = "radio", name = name, value = "2" }));
            input_friend.MergeAttributes(htmlAttributes);
            TagBuilder input_private = new TagBuilder("input");
            input_private.MergeAttributes(new RouteValueDictionary(new { id = name + "-private", type = "radio", name = name, value = "3" }));
            input_private.MergeAttributes(htmlAttributes);

            switch (selectedValue)
            {
                case PrivacyDegree.Public:
                    input_public.MergeAttribute("checked", "checked");
                    break;
                case PrivacyDegree.Friend:
                    input_friend.MergeAttribute("checked", "checked");
                    break;
                case PrivacyDegree.Private:
                    input_private.MergeAttribute("checked", "checked");
                    break;
                default:
                    break;
            }
            radioButtonList.Append(input_public.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-public", ResourceManager.GetString("Enum_PrivacyStatuses_Public", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_friend.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-friend", ResourceManager.GetString("Enum_PrivacyStatuses_OnlyFriend", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_private.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-private", ResourceManager.GetString("Enum_PrivacyStatuses_Privacy", Globals.GetCurrentUserLanguage()));

            return radioButtonList.ToString();
        }

        /// <summary>
        /// 生成SpecialPrivacyTypeRadioButtonList
        /// </summary>
        /// <param name="name">生成的radiobutton的name</param>
        /// <param name="isAllowed">初始值</param>
        /// <param name="htmlAttributes">RadioButton的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string SpecialPrivacyTypeRadioButtonList(string name, bool isAllowed, RouteValueDictionary htmlAttributes)
        {

            StringBuilder radioButtonList = new StringBuilder();
            TagBuilder input_public = new TagBuilder("input");
            input_public.MergeAttributes(new RouteValueDictionary(new { id = name + "-public", type = "radio", name = name, value = "true" }));
            input_public.MergeAttributes(htmlAttributes);
            TagBuilder input_private = new TagBuilder("input");
            input_private.MergeAttributes(new RouteValueDictionary(new { id = name + "-private", type = "radio", name = name, value = "false" }));
            input_private.MergeAttributes(htmlAttributes);

            if (isAllowed)
            {
                input_public.MergeAttribute("checked", "checked");
            }
            else
            {
                input_private.MergeAttribute("checked", "checked");
            }
            radioButtonList.Append(input_public.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-public", ResourceManager.GetString("Enum_PrivacyStatuses_Public", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_private.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-private", ResourceManager.GetString("Enum_PrivacyStatuses_Privacy", Globals.GetCurrentUserLanguage()));

            return radioButtonList.ToString();
        }

        /// <summary>
        /// 生成PrivacyActionRadioButtonList
        /// </summary>
        /// <param name="name">生成的radiobutton的name</param>
        /// <param name="selectedValue">初始选中值</param>
        /// <param name="htmlAttributes">RadioButton的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string PrivacyActionRadioButtonList(string name, PrivacyDegree selectedValue, RouteValueDictionary htmlAttributes)
        {
            StringBuilder radioButtonList = new StringBuilder();
            TagBuilder input_public = new TagBuilder("input");
            input_public.MergeAttributes(new RouteValueDictionary(new { id = name + "-public", type = "radio", name = name, value = "1" }));
            input_public.MergeAttributes(htmlAttributes);
            TagBuilder input_friend = new TagBuilder("input");
            input_friend.MergeAttributes(new RouteValueDictionary(new { id = name + "-friend", type = "radio", name = name, value = "2" }));
            input_friend.MergeAttributes(htmlAttributes);
            TagBuilder input_private = new TagBuilder("input");
            input_private.MergeAttributes(new RouteValueDictionary(new { id = name + "-private", type = "radio", name = name, value = "3" }));
            input_private.MergeAttributes(htmlAttributes);

            switch (selectedValue)
            {
                case PrivacyDegree.Public:
                    input_public.MergeAttribute("checked", "checked");
                    break;
                case PrivacyDegree.Friend:
                    input_friend.MergeAttribute("checked", "checked");
                    break;
                case PrivacyDegree.Private:
                    input_private.MergeAttribute("checked", "checked");
                    break;
                default:
                    break;
            }
            radioButtonList.Append(input_public.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-public", ResourceManager.GetString("Label_Allow", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_friend.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-friend", ResourceManager.GetString("Enum_PrivacyStatuses_OnlyFriend", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_private.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-private", ResourceManager.GetString("Label_Refuse", Globals.GetCurrentUserLanguage()));

            return radioButtonList.ToString();
        }

        /// <summary>
        /// 生成SpecialPrivacyTypeRadioButtonList
        /// </summary>
        /// <param name="name">生成的radiobutton的name</param>
        /// <param name="isAllowed">初始值</param>
        /// <param name="htmlAttributes">RadioButton的html属性，例如：new RouteValueDictionary{{"Class","editor"},{"width","90%"}}</param>
        public string SpecialPrivacyActionRadioButtonList(string name, bool isAllowed, RouteValueDictionary htmlAttributes)
        {
            StringBuilder radioButtonList = new StringBuilder();
            TagBuilder input_true = new TagBuilder("input");
            input_true.MergeAttributes(new RouteValueDictionary(new { id = name + "-true", type = "radio", name = name, value = "true" }));
            input_true.MergeAttributes(htmlAttributes);
            TagBuilder input_false = new TagBuilder("input");
            input_false.MergeAttributes(new RouteValueDictionary(new { id = name + "-false", type = "radio", name = name, value = "false" }));
            input_false.MergeAttributes(htmlAttributes);
            if (isAllowed)
                input_true.MergeAttribute("checked", "checked");
            else
                input_false.MergeAttribute("checked", "checked");
            radioButtonList.Append(input_true.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-true", ResourceManager.GetString("Label_Allow", Globals.GetCurrentUserLanguage()));
            radioButtonList.Append(input_false.ToString(TagRenderMode.SelfClosing));
            radioButtonList.AppendFormat("<label for=\"{0}\">{1}</label>", name + "-false", ResourceManager.GetString("Label_Refuse", Globals.GetCurrentUserLanguage()));
            return radioButtonList.ToString();
        }

    }
}
